package com.digiwin.athena.adt.sse.domain;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 语义对话格式
 */
@Getter
@AllArgsConstructor
public enum SseScrumEventEnum {

    SCRUMBI_ANALYSIS("scrumbi.analysis","解题步骤"),
    MESSAGE_DETAIL("message.detail","语义过程消息"),
    SCRUMBI_RESULT("scrumbi.result","解析结果"),
    SCRUMBI_COMPLEATE("scrumbi.compleate","当前步骤执行结束"),
    SCRUMBI_DONE("scrumbi.done","解析完成");

    private final String event;
    private final String desc;

    @Getter
    @AllArgsConstructor
    public enum SseEventDataTypeEnum {
        ANALYSIS("analysis","analysis","解题步骤"),
        QUESTION_WAY("questionWay","questionWay","解题思路"),
        RESULT("result","result","解析结果");
        private final String type;
        private final String defaultValue;
        private final String desc;

        public static SseAniaEventEnum.SseEventDataTypeEnum getEventDataType(String type) {
            if(StringUtils.isNotBlank(type)){
                for (SseAniaEventEnum.SseEventDataTypeEnum eventDataType : SseAniaEventEnum.SseEventDataTypeEnum.values()) {
                    if (eventDataType.getType().equals(type)) {
                        return eventDataType;
                    }
                }
            }
            return null;
        }

        public static boolean isContainType(String type) {
            return Objects.nonNull(getEventDataType(type));
        }
    }

    @Getter
    @AllArgsConstructor
    public enum EventDataMessageEnum {
        TEXT("text","文本消息");
        private final String messageType;
        private final String desc;
    }

}
