package com.digiwin.athena.adt.sse.utils;

import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

public class SseEventUtils {

    /**
     * 语义对话是否完结
     * @param answer
     * @return
     */
    public static boolean noScrumTerminate(List<EventData> answer) {
        if (CollectionUtils.isNotEmpty(answer)) {
            for (int i = answer.size() - 1; i >= 0; i--) {
                EventData item = answer.get(i);
                if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(item.getEvent())) {
                    return true;
                }
            }
        }
        return false;
    }

}
