package com.digiwin.athena.adt.util.agileData;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

public class AgileDataAnalysisUtils {

    /**
     * 回答结果组装，用于问题排查工具使用
     * @param responseData
     * @param adeResponse
     * @param event
     */
    public static void transAnalysisParams(QuerySchemaResDTO responseData, Object adeResponse, AthenaMessageEvent event){
        //只有metric模式，支持问题解析
        if(StringUtils.equals("metric",event.getMethod())) {
            Map<String, Object> analysisMap = Maps.newHashMap();
            //语义分析结果
            analysisMap.put("aiParams", responseData.getData().getMetric().getDebug());
            //ade问题分析所需入参
            analysisMap.put("analysisParams", adeResponse);
            //仅记录查询入参，供问题排查工具拉取，作为echo后续入参使用
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(analysisMap), StringUtils.EMPTY, StringUtils.EMPTY);
        }
    }

    /**
     * 获取图形转换呈现信息
     * @param adeResult
     * @param sendMap
     */
    public static void getTransShowInfo(Map<String,Object> adeResult,Map<String,Object> sendMap){
        Map<String,Object> context = MapUtils.getMap(adeResult, "context");
        if(MapUtils.isEmpty(context)){
            return;
        }
        Map<String,Object> bizParams = MapUtils.getMap(context, "bizParams");
        if(MapUtils.isEmpty(bizParams)){
            return;
        }
        List<String> transList = (List<String>) bizParams.get("transIds");
        if(CollectionUtils.isNotEmpty(transList)){
            sendMap.put("transIds",transList);
        }
        String transTips = MapUtils.getString(bizParams, "transTips");
        if(StringUtils.isNotEmpty(transTips)){
            sendMap.put("dataTipMessage",transTips);
        }
        Map<String,Object> showDefine = (Map<String, Object>) MapUtils.getObject(bizParams, "showDefine");
        if(MapUtils.isNotEmpty(showDefine)){
            //非场景结构
            List<Map<String,Object>> showTypeList = (List<Map<String, Object>>) MapUtils.getObject(showDefine, "showType");
            if(CollectionUtils.isNotEmpty(showTypeList)) {
                Map<String,Object> showType = showTypeList.get(0);
                List<Map<String, Object>> typeList = (List<Map<String, Object>>) showType.get("type");
                if (CollectionUtils.isNotEmpty(showTypeList)) {
                    Map<String, Object> typeMap = typeList.get(0);
                    sendMap.put("defaultShowType", MapUtils.getIntValue(typeMap, "value"));
                }
            }
            //场景结构
            List<Map<String,Object>> typeList = (List<Map<String, Object>>) MapUtils.getObject(showDefine, "type");
            if(CollectionUtils.isNotEmpty(typeList)) {
                Map<String, Object> typeMap = typeList.get(0);
                sendMap.put("defaultShowType", MapUtils.getIntValue(typeMap, "value"));
            }
        }
    }

}
