package com.digiwin.athena.adt.util.message;

import com.digiwin.athena.adt.domain.dto.aim.*;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.Base64Utils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.http.domain.message.MessageBatchUserDTO;
import com.digiwin.athena.atmc.http.domain.message.MessageDO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据消息封装
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
@Slf4j
public class AgileDataMessageUtils {


    private final static String MESSAGE_AIM_MSG_1 = "message.aim.msg1";

    private final static String MESSAGE_AIM_MSG_2 = "message.aim.msg2";

    private final static String MESSAGE_AIM_TITLE = "message.aim.title";

    private final static String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";

    private final static String YYYY_MM_DD = "yyyy-MM-dd";

    private final static String AIM_SOURCE_AGILE_DATA = "AGILE_DATA";

    private final static String AIM_TYPE_TEXT = "text";

    private final static String AIM_CATEGORY_NEW = "NEW";

    private final static Integer AIM_STATE = 0;

    private final static String AIM_ACTION_TYPE_DATA_SUBSCRIPTION = "AGILE_DATA_SUBSCRIPTION";

    private final static String AIM_SKILL_TYPE = "1";

    /**
     * 构建消息
     * @return
     */
    public static MessageDO buildDetectionMessage(SnapData snapData, AuthoredUser authoredUser){
        MessageDTO messageDTO = MessageDTO.builderDetectionMessage(snapData,authoredUser);
        MessageDO messageDO = sendMessage(messageDTO);
        //消息主体
        JSONObject content = new JSONObject();
        content.put("id",messageDTO.getId());
        content.put("name",messageDTO.getName());
        content.put("alertTime",messageDTO.getAlertTime() != null ? TimeUtils.format(messageDTO.getAlertTime(), "MM/dd") : null);
        content.put("title", messageDTO.getTitle());
        content.put("status", 0);
        content.put("msg",messageDTO.getMessage());
        messageDO.setContent(content);
        messageDO.setNoticeMobileApp(true);
        return messageDO;
    }

    public static MessageDO sendMessage(MessageDTO messageDTO) {
        MessageDO messageDO = new MessageDO();
        messageDO.setUserId(messageDTO.getAuthoredUser().getUserId());
        messageDO.setTenantId(messageDTO.getAuthoredUser().getTenantId());
        messageDO.setSource("athena");
        messageDO.setType(messageDTO.getMessageType());
        messageDO.setSubType(messageDTO.getMessageType());
        messageDO.setSubTypeCategory("ATHENA_REMIND");
        messageDO.setCategory(messageDO.getCategory());
        messageDO.setImportance(messageDTO.getImportance());
        messageDO.setState(messageDTO.getState());
        messageDO.setTitle("Athena");
        //语言别
        messageDO.setLangName(messageDTO.getLangName());
        return messageDO;
    }

    /**
     * 组装aim 入参
     * @param aimBuildReqDTO 获取所需信息实体
     * @return aim req
     */
    public static List<MessageBatchUserDTO> buildAgileSubscribeMessage(AimBuildReqDTO aimBuildReqDTO) {
        List<MessageBatchUserDTO> messageBatchUserDTOS = Lists.newArrayList();
        MessageDO messageDO = builderAgileSubscribe(aimBuildReqDTO);
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        List<String> userIdList = new ArrayList<>();
        userIdList.add(aimBuildReqDTO.getAuthoredUser().getUserId());
        messageBatchUserDTO.setMessage(messageDO);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(aimBuildReqDTO.getAuthoredUser().getTenantId());
        messageBatchUserDTOS.add(messageBatchUserDTO);
        return messageBatchUserDTOS;
    }

    /**
     * MessageDO 基本信息
     * @param aimBuildReqDTO aimReq
     * @return MessageDO
     */
    public static MessageDO builderAgileSubscribe(AimBuildReqDTO aimBuildReqDTO) {

        String msg1 = aimBuildReqDTO.getMessageUtil().getMessageByLangName(
                MESSAGE_AIM_MSG_1, aimBuildReqDTO.getUserLang());

        String msg2 = aimBuildReqDTO.getMessageUtil().getMessageByLangName(
                MESSAGE_AIM_MSG_2, aimBuildReqDTO.getUserLang());

        String title = aimBuildReqDTO.getMessageUtil().getMessageByLangName(
                MESSAGE_AIM_TITLE, aimBuildReqDTO.getUserLang());


        LocalDateTime nowDate = LocalDateTime.now();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        String nowFormatDate = nowDate.format(sdf);
        AimNewMessageDTO aimNewMessageDO = new AimNewMessageDTO();
        aimNewMessageDO.setLocale(aimBuildReqDTO.getUserLang());
        aimNewMessageDO.setNoticeMobileApp(true);
        aimNewMessageDO.setNoticeOnlineUser(true);
        aimNewMessageDO.setLocale(aimBuildReqDTO.getUserLang());
        AimNewActionDTO aimNewActionDTO = getAimNewActionDTO(aimBuildReqDTO, nowFormatDate);
        aimNewMessageDO.setAction(aimNewActionDTO);
        aimNewMessageDO.setSource(AIM_SOURCE_AGILE_DATA);
        aimNewMessageDO.setType(AIM_TYPE_TEXT);
        aimNewMessageDO.setCategory(AIM_CATEGORY_NEW);
        aimNewMessageDO.setState(AIM_STATE);
        aimNewMessageDO.setTitle(title);
        AimNewContentDTO aimNewContentDTO = new AimNewContentDTO();
        aimNewContentDTO.setMsg(msg1 + "【" + aimBuildReqDTO.getQuestion() + "】" + msg2);
        aimNewContentDTO.setTitle(title);
        aimNewMessageDO.setContent(aimNewContentDTO);
        aimNewMessageDO.setSendDate(nowDate);
        aimNewMessageDO.setStartTime(nowDate);
        aimNewMessageDO.setEndTime(nowDate);
        aimNewMessageDO.setCreateDate(nowDate);
        log.info("builderAgileSubscribe : {}", JsonUtils.objectToString(aimNewMessageDO));
        return aimNewMessageDO;
    }


    /**
     * aim action 新增入参 v2.0
     * @param aimBuildReqDTO aimReq组装入参
     * @param nowFormatDate  当前特定格式日期
     * @return aim action
     */
    private static AimNewActionDTO getAimNewActionDTO(AimBuildReqDTO aimBuildReqDTO, String nowFormatDate) {
        AimNewActionDTO aimNewActionDTO = new AimNewActionDTO();
        aimNewActionDTO.setTarget(AIM_SOURCE_AGILE_DATA);
        aimNewActionDTO.setAssistantCode(aimBuildReqDTO.getAsaCode());
        aimNewActionDTO.setSkillType(AIM_SKILL_TYPE);
        aimNewActionDTO.setType(AIM_ACTION_TYPE_DATA_SUBSCRIPTION);
        AimNewAdaParamsDTO adaParams = new AimNewAdaParamsDTO();
        adaParams.setQuestion(aimBuildReqDTO.getQuestion());
        adaParams.setSnapshotId(aimBuildReqDTO.getSnapData().getSnapshotId());
        adaParams.setSendDate(nowFormatDate);
        adaParams.setMethod(aimBuildReqDTO.getMethod());
        adaParams.setUndeletable(aimBuildReqDTO.isUndeletable());
        adaParams.setDataTipMessage(aimBuildReqDTO.getDataTipMessage());
        adaParams.setAssistantCode(aimBuildReqDTO.getAsaCode());
        adaParams.setRuleId(aimBuildReqDTO.getRuleId());
        List<Map<String, Object>> metricList = aimBuildReqDTO.getMetricList();
        List<String> metricIdList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(metricList)){
            for (Map<String, Object> map : metricList) {
                if (map.containsKey("metricId")) {
                    Object metricIdObj = map.get("metricId");
                    if (metricIdObj instanceof String) {
                        metricIdList.add((String) metricIdObj);
                    }
                }
            }
        }
        adaParams.setMetricIdList(metricIdList);

        List<Map<String, Object>> datasetList = aimBuildReqDTO.getDatasetList();
        List<String> datasetIdList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(datasetList)){
            for (Map<String, Object> map : datasetList) {
                if (map.containsKey("datasetId")) {
                    Object datasetIdObj = map.get("datasetId");
                    if (datasetIdObj instanceof String) {
                        datasetIdList.add((String) datasetIdObj);
                    }
                }
            }
        }
        adaParams.setDatasetIdList(datasetIdList);
        //娜娜跳转参数
        List<AimNewActionDTO.AimUrlParams> urlParams = Lists.newArrayList();
        //第三方订阅特殊标识
        AimNewActionDTO.AimUrlParams redirectUrl = new AimNewActionDTO.AimUrlParams();
        redirectUrl.setKey("redirectUrl");
        redirectUrl.setValue("nanaSubscriptionDetail");
        //用户
        AimNewActionDTO.AimUrlParams userId = new AimNewActionDTO.AimUrlParams();
        userId.setKey("userId");
        userId.setValue(aimBuildReqDTO.getAuthoredUser().getUserId());
        //租户
        AimNewActionDTO.AimUrlParams tenantId = new AimNewActionDTO.AimUrlParams();
        tenantId.setKey("tenantId");
        tenantId.setValue(aimBuildReqDTO.getAuthoredUser().getTenantId());
        //娜娜参数
        Map<String,Object> nanaMap = Maps.newHashMap();
        nanaMap.put("assistantCode",aimBuildReqDTO.getAsaCode());
        AimNewActionDTO.AimUrlParams nanaParams = new AimNewActionDTO.AimUrlParams();
        nanaParams.setKey("nanaParams");
        nanaParams.setValue(Base64Utils.encode(JsonUtils.objectToString(nanaMap)));
        //快照
        AimNewActionDTO.AimUrlParams snapshotId = new AimNewActionDTO.AimUrlParams();
        snapshotId.setKey("snapshotId");
        snapshotId.setValue(aimBuildReqDTO.getSnapData().getSnapshotId());
        AimNewActionDTO.AimUrlParams sendDate = new AimNewActionDTO.AimUrlParams();
        sendDate.setKey("sendDate");
        sendDate.setValue(nowFormatDate);
        AimNewActionDTO.AimUrlParams undeletable = new AimNewActionDTO.AimUrlParams();
        undeletable.setKey("undeletable");
        undeletable.setValue(Boolean.toString(aimBuildReqDTO.isUndeletable()));
        urlParams.add(redirectUrl);
        urlParams.add(tenantId);
        urlParams.add(userId);
        urlParams.add(nanaParams);
        urlParams.add(snapshotId);
        urlParams.add(sendDate);
        urlParams.add(undeletable);
        aimNewActionDTO.setUrlParams(urlParams);
        aimNewActionDTO.setAdaParams(adaParams);
        return aimNewActionDTO;
    }


}
