package com.digiwin.athena.adt.util.message;

import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.adt.util.MessageUtil;
import lombok.Data;
import org.springframework.context.i18n.LocaleContextHolder;

import java.time.LocalDateTime;

@Data
public class MessageDTO {

    /**
     * 用户
     */
    private AuthoredUser authoredUser;

    /**
     * 语言别
     */
    private String langName;

    /**
     * 提醒名称
     */
    private String name;

    /**
     * 跳转ID
     */
    private String id;

    /**
     * 开始时间
     */
    private LocalDateTime alertTime;

    /**
     * 消息状态
     */
    private Integer status;

    /**
     * 标题
     */
    private String title;

    /**
     *标题
     */
    private String message;

    /**
     * 消息类型
     */
    private String messageType;

    /**
     * 消息类别
     */
    private String category;

    /**
     * 消息状态
     */
    private Integer state;

    /**
     * 重要性
     */
    private Integer importance;

    public static MessageDTO builderDetectionMessage(SnapData snapData,AuthoredUser authoredUser) {
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setAuthoredUser(authoredUser);
        messageDTO.setMessageType("AGILE_DATA_DETAIL");
        messageDTO.setCategory("SIGN_NOTICE");
        messageDTO.setImportance(0);
        messageDTO.setState(0);
        messageDTO.setStatus(0);
        messageDTO.setLangName(LocaleContextHolder.getLocale().toLanguageTag());
        messageDTO.setId(snapData.getSnapshotId());
        messageDTO.setName(MessageUtil.getMessageByLanguage(snapData.getTitle(), messageDTO.getLangName()));
        messageDTO.setAlertTime(snapData.getRequestTime());
        messageDTO.setTitle(snapData.getTitle());
        messageDTO.setMessage(snapData.getTitle());
        return messageDTO;
    }
}
