/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.log;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.agileReport.service.AgileReportFeedBackService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agileDataFeedback"})
public class AgileReportFeedbackController {
    @Autowired
    private AgileReportFeedBackService agileReportFeedBackService;

    @PostMapping(value={"/user/feedback"})
    public ResponseEntity<?> userFeedback(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        String clientAgent = request.getHeader("client-agent");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportFeedBackService.saveFeedback(user, agileDataFeedBackDTO, clientAgent));
    }

    @PostMapping(value={"/user/cancel"})
    public ResponseEntity<?> cancelFeedback(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        this.agileReportFeedBackService.deleteFeedback(user, agileDataFeedBackDTO);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    @PostMapping(value={"/user/answerBack"})
    public ResponseEntity<?> answerBack(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        this.agileReportFeedBackService.answerBack(user, agileDataFeedBackDTO);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    @PostMapping(value={"/user/getFeedback"})
    public ResponseEntity<?> getFeedback(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody List<Long> generateSerialNoList) {
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportFeedBackService.getFeedback(user, generateSerialNoList));
    }
}

