/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataMoreActionDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.dto.SDScencDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PageReqDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile"})
public class AgileReportDataController {
    @Autowired
    private SnapShotDataService snapShotDataService;

    @PostMapping(value={"/report/getDetail"})
    public ResponseEntity<?> getReportDetail(@RequestBody AgileReportDetailParamsDTO agileReportDetailParamsDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSnapShotDetail(agileReportDetailParamsDTO, user));
    }

    @PostMapping(value={"/report/page/getDetail"})
    public ResponseEntity<?> getReportPageDetail(@RequestBody AgileReportDetailParamsDTO agileReportDetailParamsDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSnapPageShotDetail(agileReportDetailParamsDTO, user));
    }

    @PostMapping(value={"/report/getIntentionData"})
    public ResponseEntity<?> getIntentionReport(@RequestBody SDScencDTO sdScencDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getScencDetail(sdScencDTO, user));
    }

    @PostMapping(value={"/report/getData/list"})
    public ResponseEntity<?> getSnapShotDataList(@RequestBody PageReqDTO pageReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSnapShotDataList(user.getTenantId(), user.getUserId(), pageReqDTO));
    }

    @GetMapping(value={"/report/getSnapData/{snapshotId}"})
    public ResponseEntity<?> getSnapShotData(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSnapDataInfoBySnapshotId(user.getTenantId(), user.getUserId(), snapshotId));
    }

    @PostMapping(value={"/report/getSyncScreenSnapData"})
    public ResponseEntity<?> getSyncScreenSnapData(HttpServletRequest request, @RequestBody AgileDataMoreActionDTO agileDataMoreActionDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getScreenSnapSyncData(user, agileDataMoreActionDTO, locale));
    }

    @GetMapping(value={"/report/getScreenSnapData"})
    public ResponseEntity<?> getScreenSnapShotData(@RequestParam(value="sceneCode", required=false) String sceneCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getScreenSnapData(user.getTenantId(), user.getUserId(), sceneCode));
    }

    @GetMapping(value={"/report/getData/{snapshotId}"})
    public ResponseEntity<?> getReportInfoBysnapshotId(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId()));
    }

    @GetMapping(value={"/report/updateReadCount/{snapshotId}"})
    public ResponseEntity<?> updateReadCount(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.snapShotDataService.updateReadCount(snapshotId, user.getTenantId(), user.getUserId());
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/report/deleteSnap"})
    public ResponseEntity<?> deleteSnap(@RequestBody Map<String, Object> map, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String snapshotId = MapUtils.getString(map, (Object)"snapshotId", (String)"");
        this.snapShotDataService.deleteSnap(snapshotId, user.getTenantId(), user.getUserId());
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/report/updateSnapsStatue"})
    public ResponseEntity<?> updateSnapsStatue(@RequestBody Map<String, Object> map, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String snapshotId = MapUtils.getString(map, (Object)"snapshotId", (String)"");
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.updateSnapsStatue(snapshotId, user.getTenantId(), user.getUserId()));
    }

    @GetMapping(value={"/report/getAamData/{snapshotId}"})
    public ResponseEntity<?> getAamDataBySnapshotId(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getAamDataBySnapshotId(snapshotId, user.getTenantId(), user.getUserId()));
    }

    @GetMapping(value={"/getThirdPartyAgileData/{snapshotId}"})
    public ResponseEntity<?> getThirdPartyAgileData(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getThirdPartyAgileData(snapshotId, user));
    }

    @GetMapping(value={"/report/getSolutionStep/{snapshotId}"})
    public ResponseEntity<?> getSolutionStepBySnapshotId(@PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.snapShotDataService.getSolutionStepBySnapshotId(snapshotId, user.getTenantId(), user.getUserId()));
    }
}

