/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.event.domain;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class SendMessageReqDTO
implements Serializable {
    private SendMessageDTO sendMessageDTO;
    private String token;
    private String question;
    private String combinationQuestion;
    private List<String> sentences;
    private Long generateSerialNo;
    private Integer answerResult;
    private String messageType;
    private String tenantId;
    private String questionUnderstand;
    private boolean getMessageInfo;

    public static SendMessageReqDTO builderMessageAndType(AthenaMessageEvent event, Map<String, Object> messageBody) {
        SendMessageReqDTO sendMessageReqDTO = new SendMessageReqDTO();
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageDTO.setMsgBody(messageBody);
        sendMessageDTO.setMsgExt(event.getMsgExt());
        sendMessageDTO.setMethod(event.getMethod());
        sendMessageDTO.setGetMessageInfo(event.isGetMessageInfo());
        if (CollectionUtils.isNotEmpty((Collection)event.getMetricList())) {
            List filteredList = event.getMetricList().stream().map(SendMessageReqDTO::extractMetricIdAndName).collect(Collectors.toList());
            sendMessageDTO.setMetricList(filteredList);
        } else {
            sendMessageDTO.setMetricList(event.getMetricList());
        }
        sendMessageDTO.setAsaCode(event.getAsaCode());
        if (event.isDebug() && AgileDataEnum.METRIC.getCode().equals(event.getMethod())) {
            sendMessageDTO.setDebugModel(AgileDataEnum.METRIC.getCode());
        }
        sendMessageDTO.setMessageId(event.getGenerateSerialNo());
        sendMessageDTO.setUserId(event.getUser().getUserId());
        sendMessageReqDTO.setSendMessageDTO(sendMessageDTO);
        sendMessageReqDTO.setToken(event.getUser().getToken());
        sendMessageReqDTO.setTenantId(event.getUser().getTenantId());
        sendMessageReqDTO.setQuestion(event.getQuestion());
        sendMessageReqDTO.setCombinationQuestion(event.getCombinationQuestion());
        sendMessageReqDTO.setQuestionUnderstand(event.getQuestionUnderstand());
        sendMessageReqDTO.setGenerateSerialNo(event.getGenerateSerialNo());
        sendMessageReqDTO.setSentences(event.getSentences());
        sendMessageReqDTO.setAnswerResult(event.getAnswerResult());
        sendMessageReqDTO.setMessageType(event.getMessageType());
        sendMessageReqDTO.setGetMessageInfo(event.isGetMessageInfo());
        return sendMessageReqDTO;
    }

    public static Map<String, Object> extractMetricIdAndName(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("metricId", map.get("metricId"));
        newMap.put("metricName", map.get("metricName"));
        return newMap;
    }

    public SendMessageDTO getSendMessageDTO() {
        return this.sendMessageDTO;
    }

    public String getToken() {
        return this.token;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getCombinationQuestion() {
        return this.combinationQuestion;
    }

    public List<String> getSentences() {
        return this.sentences;
    }

    public Long getGenerateSerialNo() {
        return this.generateSerialNo;
    }

    public Integer getAnswerResult() {
        return this.answerResult;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getQuestionUnderstand() {
        return this.questionUnderstand;
    }

    public boolean isGetMessageInfo() {
        return this.getMessageInfo;
    }

    public void setSendMessageDTO(SendMessageDTO sendMessageDTO) {
        this.sendMessageDTO = sendMessageDTO;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setQuestion(String question2) {
        this.question = question2;
    }

    public void setCombinationQuestion(String combinationQuestion) {
        this.combinationQuestion = combinationQuestion;
    }

    public void setSentences(List<String> sentences) {
        this.sentences = sentences;
    }

    public void setGenerateSerialNo(Long generateSerialNo) {
        this.generateSerialNo = generateSerialNo;
    }

    public void setAnswerResult(Integer answerResult) {
        this.answerResult = answerResult;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setQuestionUnderstand(String questionUnderstand) {
        this.questionUnderstand = questionUnderstand;
    }

    public void setGetMessageInfo(boolean getMessageInfo) {
        this.getMessageInfo = getMessageInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageReqDTO)) {
            return false;
        }
        SendMessageReqDTO other = (SendMessageReqDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SendMessageDTO this$sendMessageDTO = this.getSendMessageDTO();
        SendMessageDTO other$sendMessageDTO = other.getSendMessageDTO();
        if (this$sendMessageDTO == null ? other$sendMessageDTO != null : !this$sendMessageDTO.equals(other$sendMessageDTO)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$combinationQuestion = this.getCombinationQuestion();
        String other$combinationQuestion = other.getCombinationQuestion();
        if (this$combinationQuestion == null ? other$combinationQuestion != null : !this$combinationQuestion.equals(other$combinationQuestion)) {
            return false;
        }
        List this$sentences = this.getSentences();
        List other$sentences = other.getSentences();
        if (this$sentences == null ? other$sentences != null : !((Object)this$sentences).equals(other$sentences)) {
            return false;
        }
        Long this$generateSerialNo = this.getGenerateSerialNo();
        Long other$generateSerialNo = other.getGenerateSerialNo();
        if (this$generateSerialNo == null ? other$generateSerialNo != null : !((Object)this$generateSerialNo).equals(other$generateSerialNo)) {
            return false;
        }
        Integer this$answerResult = this.getAnswerResult();
        Integer other$answerResult = other.getAnswerResult();
        if (this$answerResult == null ? other$answerResult != null : !((Object)this$answerResult).equals(other$answerResult)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$questionUnderstand = this.getQuestionUnderstand();
        String other$questionUnderstand = other.getQuestionUnderstand();
        if (this$questionUnderstand == null ? other$questionUnderstand != null : !this$questionUnderstand.equals(other$questionUnderstand)) {
            return false;
        }
        return this.isGetMessageInfo() == other.isGetMessageInfo();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMessageReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SendMessageDTO $sendMessageDTO = this.getSendMessageDTO();
        result = result * 59 + ($sendMessageDTO == null ? 43 : $sendMessageDTO.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $combinationQuestion = this.getCombinationQuestion();
        result = result * 59 + ($combinationQuestion == null ? 43 : $combinationQuestion.hashCode());
        List $sentences = this.getSentences();
        result = result * 59 + ($sentences == null ? 43 : ((Object)$sentences).hashCode());
        Long $generateSerialNo = this.getGenerateSerialNo();
        result = result * 59 + ($generateSerialNo == null ? 43 : ((Object)$generateSerialNo).hashCode());
        Integer $answerResult = this.getAnswerResult();
        result = result * 59 + ($answerResult == null ? 43 : ((Object)$answerResult).hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $questionUnderstand = this.getQuestionUnderstand();
        result = result * 59 + ($questionUnderstand == null ? 43 : $questionUnderstand.hashCode());
        result = result * 59 + (this.isGetMessageInfo() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SendMessageReqDTO(sendMessageDTO=" + this.getSendMessageDTO() + ", token=" + this.getToken() + ", question=" + this.getQuestion() + ", combinationQuestion=" + this.getCombinationQuestion() + ", sentences=" + this.getSentences() + ", generateSerialNo=" + this.getGenerateSerialNo() + ", answerResult=" + this.getAnswerResult() + ", messageType=" + this.getMessageType() + ", tenantId=" + this.getTenantId() + ", questionUnderstand=" + this.getQuestionUnderstand() + ", getMessageInfo=" + this.isGetMessageInfo() + ")";
    }
}

