/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.MonitorDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmUserResponseDto;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SnapShotCommonService {
    private static final Logger log = LoggerFactory.getLogger(SnapShotCommonService.class);
    @Autowired
    private AgileReportDataService agileReportDataService;
    @Autowired
    private SnapShotDataService snapShotDataService;

    public void processAndSaveSnapShotData(String snapDataJsonString, SnapShotDTO snapShotDTO, AuthoredUser user) {
        String uploadFileId = "";
        try {
            if (snapShotDTO != null) {
                String monitorRuleId = Optional.ofNullable(snapShotDTO).map(SnapShotDTO::getContext).map(ContextDTO::getBizParams).map(BizParamsDTO::getMonitor).map(MonitorDTO::getMonitorRuleId).orElse(null);
                List<TmUserResponseDto> userResponses = Lists.newArrayList();
                if (StringUtils.isNotEmpty((CharSequence)monitorRuleId)) {
                    userResponses = this.snapShotDataService.getUserResponse(snapShotDTO);
                } else {
                    TmUserResponseDto tmUserResponseDto = new TmUserResponseDto();
                    tmUserResponseDto.setUserId(snapShotDTO.getContext().getBizParams().getRequestPerson());
                    tmUserResponseDto.setUserName(snapShotDTO.getContext().getBizParams().getRequestPersonName());
                    userResponses.add(tmUserResponseDto);
                }
                if (userResponses == null || userResponses.isEmpty()) {
                    throw ErrorCodeEnum.USERINFO_IS_EMPTY.getBusinessException();
                }
                log.info("\u5feb\u7167\u670d\u52a1\u6d88\u606f{},message:{}", (Object)snapShotDTO.getSnapshotId(), (Object)snapDataJsonString);
                uploadFileId = this.agileReportDataService.processSDData(JsonUtils.objectToString((Object)snapShotDTO), snapShotDTO.getSnapshotId(), user);
                this.snapShotDataService.saveSnapShotData(snapShotDTO, uploadFileId, userResponses);
                LogUtils.buildAgileLog((String)"adt", (String)"snapshotSave", (String)"1", (String)snapDataJsonString, (String)uploadFileId, (String)"");
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"snapshotSave", (String)TroubleToolCodeEnum.ADT_901_0127.getErrCode(), (String)JsonUtils.objectToString((Object)snapDataJsonString), (String)TroubleToolCodeEnum.ADT_901_0127.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0127.getSuggestion());
        }
    }
}

