/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.ania;

import com.digiwin.athena.adt.agileReport.service.AniaAssistantService;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantResDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataCustomConfig;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class AniaAssistantServiceImpl
implements AniaAssistantService {
    @Autowired
    private KmService kmService;
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoTemplate;
    @Value(value="${adt.url:}")
    private String adtUrl;

    public AniaAssistantResDTO getPublishedInfo(AniaAssistantReqDTO req, AuthoredUser user) {
        List assistantReq = req.getAssistant();
        AniaAssistantResDTO res = new AniaAssistantResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistantList = new ArrayList<AniaAssistantResDTO.Assistant>();
        for (AniaAssistantReqDTO.Assistant dto : assistantReq) {
            String appCode = dto.getAssistantId();
            String version = dto.getVersion();
            AgileDataCustomConfig config = new AgileDataCustomConfig();
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(user, appCode);
            int appType = 6;
            if (Objects.nonNull(cIData) && Objects.nonNull(cIData.getAppType())) {
                appType = cIData.getAppType();
            }
            AgileDataCustomConfig configReq = new AgileDataCustomConfig();
            configReq.setVersion(appType == 12 ? "V2" : "V1");
            List customConfigs = this.getMongoCustomConfig(configReq, user);
            if (CollectionUtils.isNotEmpty((Collection)customConfigs)) {
                config = (AgileDataCustomConfig)customConfigs.get(0);
            }
            AniaAssistantResDTO.Assistant assistant = AniaAssistantResDTO.Assistant.builderAssistant((String)version, (String)appCode, (KMDatasetCommandIntentionsResDTO)cIData, (AgileDataCustomConfig)config, (String)this.adtUrl);
            assistantList.add(assistant);
        }
        res.setAssistant(assistantList);
        return res;
    }

    public void saveCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List results = this.mongoTemplate.find(query, AgileDataCustomConfig.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Update update = new Update();
            update.set("pluginCustoms", (Object)agileDataCustomConfig.getPluginCustoms());
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, AgileDataCustomConfig.class);
        } else {
            this.mongoTemplate.insert((Object)agileDataCustomConfig);
        }
    }

    public List<AgileDataCustomConfig> getMongoCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return this.mongoTemplate.find(query, AgileDataCustomConfig.class);
    }

    public AniaVersionResDTO getVersion(AniaVersionReqDTO req, AuthoredUser user) {
        AniaVersionResDTO res = new AniaVersionResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistant = new ArrayList<AniaAssistantResDTO.Assistant>();
        String version = this.kmService.getVersion(user);
        if (Objects.nonNull(version)) {
            AniaAssistantResDTO.Assistant versionBean = new AniaAssistantResDTO.Assistant();
            versionBean.setAssistantId(req.getAssistantId());
            versionBean.setVersion(version);
            assistant.add(versionBean);
        }
        res.setAssistant(assistant);
        return res;
    }

    public AniaAssistantResDTO getInspirationPhrases(AniaAssistantReqDTO req, AuthoredUser user) {
        List assistantReq = req.getAssistant();
        AniaAssistantResDTO result = new AniaAssistantResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistantList = new ArrayList<AniaAssistantResDTO.Assistant>();
        for (AniaAssistantReqDTO.Assistant dto : assistantReq) {
            AniaAssistantResDTO.Assistant assistant = new AniaAssistantResDTO.Assistant();
            String appCode = dto.getAssistantId();
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(user, appCode);
            List commandIntentions = new ArrayList();
            if (Objects.nonNull(cIData) && StringUtils.isNotEmpty((CharSequence)cIData.getApplicationName()) && CollectionUtils.isNotEmpty((Collection)cIData.getCommandIntentions())) {
                commandIntentions = cIData.getCommandIntentions();
            }
            List phrases = AniaAssistantResDTO.Assistant.InspirationPhrases.builderInspirationPhrases(commandIntentions);
            assistant.setInspirationPhrases(phrases);
            assistant.setAssistantId(appCode);
            assistantList.add(assistant);
        }
        result.setAssistant(assistantList);
        return result;
    }

    public void deleteMongoCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.remove(query, "agile_data_custom_config");
    }
}

