/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMongoService;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMysqlService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AgileDataMessageLogEventServiceImpl
implements AgileDataMessageLogEventService {
    @Autowired
    private AgileReportLogMongoService agileReportLogMongoService;
    @Autowired
    private AgileReportLogMysqlService agileReportLogMysqlService;
    @Qualifier(value="ADEServiceImpl")
    @Autowired
    private ADEService adeService;

    @Async(value="asyncLogServiceExecutor")
    public void processLog(AgileDataLogEvent event) {
        AppAuthContextHolder.clearContext();
        Map schemaMap = Maps.newHashMap();
        if (event.isMessageGet() && Objects.nonNull(event.getAdeScencDTO())) {
            Map queryMap = this.adeService.getSchemaSQLNoGPT(event);
            schemaMap = MapUtils.getMap((Map)queryMap, (Object)"data", (Map)Maps.newHashMap());
        }
        this.agileReportLogMongoService.saveLog(event, schemaMap);
        this.agileReportLogMysqlService.saveLog(event, schemaMap);
    }
}

