/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataLogMapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataLogSqlMapper;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMysqlService;
import com.digiwin.athena.adt.domain.dto.km.KMPurchaseModelResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataLog;
import com.digiwin.athena.adt.domain.po.AgileDataLogSql;
import com.digiwin.athena.adt.util.DateUtils;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgileReportLogMysqlServiceImpl
implements AgileReportLogMysqlService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportLogMysqlServiceImpl.class);
    @Autowired
    private AgileDataLogMapper agileDataLogMapper;
    @Autowired
    private AgileDataLogSqlMapper agileDataLogSqlMapper;
    @Autowired
    private KmService kmService;
    private static final String TENANT_ID = "tenant_id";
    private static final String USER_ID = "user_id";
    private static final String GENERATESERIALNO = "generate_serial_no";
    private static final String SNAPSHOT_ID = "snapshot_id";

    @Transactional(rollbackFor={Exception.class})
    public Boolean saveLog(AgileDataLogEvent agileDataLogEvent, Map<String, Object> schemaMap) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)agileDataLogEvent.getAuthoredUser().getTenantId())).eq((Object)USER_ID, (Object)agileDataLogEvent.getAuthoredUser().getUserId())).eq((Object)GENERATESERIALNO, (Object)agileDataLogEvent.getGenerateSerialNo());
        AgileDataLog dataLog = (AgileDataLog)this.agileDataLogMapper.selectOne((Wrapper)queryWrapper);
        if (dataLog == null) {
            Map sqlSchemaMaps;
            AgileDataLog agileDataLog = new AgileDataLog();
            BeanUtils.copyProperties((Object)agileDataLogEvent, (Object)agileDataLog);
            this.checkAppCode(agileDataLogEvent, agileDataLog);
            agileDataLog.setUserName(agileDataLogEvent.getAuthoredUser().getUserName());
            agileDataLog.setUserId(agileDataLogEvent.getAuthoredUser().getUserId());
            agileDataLog.setTenantId(agileDataLogEvent.getAuthoredUser().getTenantId());
            agileDataLog.setTenantName(agileDataLogEvent.getAuthoredUser().getTenantName());
            agileDataLog.setCreateTime(agileDataLogEvent.getAskTime());
            agileDataLog.setAnswerTime(agileDataLogEvent.getAnswerTime());
            agileDataLog.setResSecTime(DateUtils.calculateAndSetDuration((LocalDateTime)agileDataLogEvent.getAskTime(), (LocalDateTime)agileDataLogEvent.getAnswerTime()));
            this.agileDataLogMapper.insert((Object)agileDataLog);
            if (MapUtils.isNotEmpty(schemaMap) && schemaMap.containsKey("sqlSchemaMaps") && MapUtils.isNotEmpty((Map)(sqlSchemaMaps = MapUtils.getMap(schemaMap, (Object)"sqlSchemaMaps")))) {
                ArrayList agileDataLogSqlList = Lists.newArrayList();
                sqlSchemaMaps.forEach((k, v) -> {
                    AgileDataLogSql agileDataLogSql = new AgileDataLogSql();
                    agileDataLogSql.setLogId(agileDataLog.getId());
                    agileDataLogSql.setQueryTitle(k);
                    agileDataLogSql.setQuerySql(v.toString());
                    agileDataLogSqlList.add(agileDataLogSql);
                });
                this.agileDataLogSqlMapper.insertBatchSomeColumn((Collection)agileDataLogSqlList);
            }
        } else {
            this.updateLog(agileDataLogEvent, dataLog);
        }
        return true;
    }

    public void checkAppCode(AgileDataLogEvent agileDataLogEvent, AgileDataLog agileDataLog) {
        String token = agileDataLogEvent.getAuthoredUser().getToken();
        String tenantId = agileDataLogEvent.getAuthoredUser().getTenantId();
        String userId = agileDataLogEvent.getAuthoredUser().getUserId();
        String appCode = agileDataLogEvent.getApplicationCode();
        List apps = this.kmService.queryKmPurchaseList(Integer.valueOf(1), token, tenantId, userId);
        if (StringUtils.isEmpty((CharSequence)appCode) && apps.size() == 1) {
            agileDataLog.setApplicationName(((KMPurchaseModelResDTO)apps.get(0)).getName());
            agileDataLog.setApplicationCode(((KMPurchaseModelResDTO)apps.get(0)).getCode());
        }
    }

    public Boolean removeLog(AgileDataLogEvent agileDataLogEvent) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)agileDataLogEvent.getAuthoredUser().getTenantId())).eq((Object)USER_ID, (Object)agileDataLogEvent.getAuthoredUser().getUserId())).eq((Object)SNAPSHOT_ID, (Object)agileDataLogEvent.getSnapshotId());
        this.agileDataLogMapper.delete((Wrapper)queryWrapper);
        return true;
    }

    private void updateLog(AgileDataLogEvent agileDataLogEvent, AgileDataLog dataLog) {
        AgileDataLog agileDataLog = new AgileDataLog();
        agileDataLog.setUserName(agileDataLogEvent.getAuthoredUser().getUserName());
        agileDataLog.setUserId(agileDataLogEvent.getAuthoredUser().getUserId());
        agileDataLog.setTenantId(agileDataLogEvent.getAuthoredUser().getTenantId());
        agileDataLog.setTenantName(agileDataLogEvent.getAuthoredUser().getTenantName());
        agileDataLog.setGenerateSerialNo(agileDataLogEvent.getGenerateSerialNo());
        switch (agileDataLogEvent.getType()) {
            case 1: {
                agileDataLog.setErrorAnswer(agileDataLogEvent.getErrorAnswer());
                agileDataLog.setSuccess(agileDataLogEvent.getSuccess());
                break;
            }
            case 2: {
                agileDataLog.setFeedbackType(agileDataLogEvent.getFeedbackType());
                if (dataLog.getCreateBackTime() != null) break;
                agileDataLog.setCreateBackTime(LocalDateTime.now());
                break;
            }
            case 3: {
                agileDataLog.setAnswerOpinion(agileDataLogEvent.getAnswerOpinion());
                agileDataLog.setBackContent(agileDataLogEvent.getBackContent());
                agileDataLog.setCheckOpinions(agileDataLogEvent.getCheckOpinions());
                if (dataLog.getCreateBackTime() != null) break;
                agileDataLog.setCreateBackTime(LocalDateTime.now());
                break;
            }
            case 4: {
                agileDataLog.setFeedbackType(agileDataLogEvent.getFeedbackType());
                agileDataLog.setAnswerOpinion(agileDataLogEvent.getAnswerOpinion());
                agileDataLog.setBackContent(agileDataLogEvent.getBackContent());
                agileDataLog.setCheckOpinions(agileDataLogEvent.getCheckOpinions());
                agileDataLog.setCreateBackTime(null);
                break;
            }
        }
        agileDataLog.setModifyTime(LocalDateTime.now());
        this.agileDataLogMapper.updateAgileDataLog(agileDataLog);
    }
}

