/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.DATASET)
public class AgileDataProcessDatasetServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessDatasetServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        String question2 = event.getQuestion();
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
        LogDto logDto = new LogDto("\u83b7\u53d6\u610f\u56fe\u8bc6\u522b\u6570\u636e\uff1a" + JsonUtils.objectToString((Object)responseData));
        log.info(logDto.toString());
        try {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
            Map req = this.processBefore(event, responseData);
            this.processAfter(event, req, responseData);
        }
        catch (Exception e) {
            HashMap<String, String> msgBody = new HashMap<String, String>();
            log.error("ade message sendMessageToAde error: {}", (Object)e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            msgBody.put("prompt", tipMessage);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, msgBody);
            Thread.currentThread().interrupt();
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
    }

    public Map<String, Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) throws ExecutionException, InterruptedException {
        AtomicBoolean state = new AtomicBoolean(false);
        CountDownLatch returnResultLatch = new CountDownLatch(1);
        String productVersion = event.getProductVersion();
        Map req = this.parameterBasedOnVersion(responseData, event);
        if (event.isSseMessage()) {
            log.info("send \u8981\u7d20\u8bc6\u522b\u4f1a\u8bdd\u5f00\u59cb");
            HashMap<String, Object> messageObj = new HashMap<String, Object>();
            String messageTitle = this.messageUtil.getMessageByLangNameWithFormat("message.sse.essentialFactor", event.getLang(), new Object[0]);
            messageObj.put("name", messageTitle);
            messageObj.put("arguments ", new HashMap());
            EventData.EventMessage eventMessage = "V1".equals(productVersion) ? EventData.EventMessage.builderNewEventMessage((String)"function_call", messageObj, (AthenaMessageEvent)event) : EventData.EventMessage.builderNewEventMessageV2((String)"function_call", (Object)messageTitle, (AthenaMessageEvent)event);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), eventMessage);
        }
        CompletableFuture<Boolean> getEssentialFactor = CompletableFuture.supplyAsync(() -> {
            this.getEssentialFactorAndSendSseMessage(event, req, state, returnResultLatch);
            returnResultLatch.countDown();
            return true;
        });
        CompletableFuture<Map> adeResult = CompletableFuture.supplyAsync(() -> {
            Map res = this.adeService.reqMetricSnapShotData(req, event);
            state.set(true);
            try {
                boolean awaitResult = returnResultLatch.await(60L, TimeUnit.SECONDS);
                if (awaitResult) {
                    log.info("Condition is satisfied");
                } else {
                    log.info("Condition is not satisfied");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (res == null || MapUtils.getMap((Map)res, (Object)"data") == null) {
                if (event.isSseMessage()) {
                    EventData.EventMessage toolResponse = "V1".equals(productVersion) ? EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"fail") : EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"fail");
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), toolResponse);
                }
                String errorMsg = MapUtils.getString((Map)res, (Object)"msg");
                HashMap sendMap = Maps.newHashMap();
                sendMap.put("prompt", errorMsg);
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
                this.semcService.sendMessageToGpt(event, (Map)sendMap);
                return null;
            }
            return res;
        });
        getEssentialFactor.get();
        log.info("send \u53d6\u6570\u7ed3\u675f");
        if (event.isSseMessage()) {
            EventData.EventMessage toolResponse = "V1".equals(productVersion) ? EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"success") : EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"success");
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), toolResponse);
        }
        return adeResult.get();
    }

    public void processAfter(AthenaMessageEvent event, Map<String, Object> response, QuerySchemaResDTO responseData) {
        if (Objects.isNull(response)) {
            return;
        }
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        try {
            boolean isCheck;
            HashMap sendMap = Maps.newHashMap();
            Map data = MapUtils.getMap(response, (Object)"data");
            Pair interception = this.isDataProcessAction(data);
            if (((Boolean)interception.getLeft()).booleanValue()) {
                this.echoService.echoMongodbSubmit(EchoSubmitReq.builderInterception((AthenaMessageEvent)event, (MessageUtil)this.messageUtil, (Integer)((Integer)interception.getRight())), event.getUser().getToken(), event.getUser().getTenantId());
            }
            String snapshotId = MapUtils.getString((Map)data, (Object)"snapshotId");
            sendMap.put("snapshotId", snapshotId);
            this.executeStepAnalysis(event, response);
            this.setDataSummary(data, event);
            AgileDataAnalysisUtils.getTransShowInfo((Map)data, (Map)sendMap);
            this.agileReportService.executeAgileDataByTokenSize(event.getUser(), event, data);
            this.saveQuestionData(MapUtils.getMap(response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
            this.saveBuiltClassifications(event, response);
            if (StringUtils.isNotEmpty((CharSequence)snapshotId)) {
                this.agileDataCostDetailService.saveAgileDataCostDetail(data, event.getUser(), event.getPtxId(), event.getAppCode(), event.getAppName(), event.getSourceName());
            }
            if (!(isCheck = this.agileDataCalculateCostService.combinedBillingCalculation(event, data, (Map)sendMap))) {
                return;
            }
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
        }
        catch (Exception e) {
            HashMap sendMap = Maps.newHashMap();
            sendMap.put("prompt", e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
        }
    }

    public void executeStepAnalysis(AthenaMessageEvent event, Map<String, Object> response) {
        ArrayList steps = Lists.newArrayList();
        Map contextMap = MapUtils.getMap((Map)MapUtils.getMap(response, (Object)"data"), (Object)"context");
        Object step = contextMap.get("stepAnalysis");
        if (Objects.nonNull(step)) {
            steps.addAll((Collection)step);
        }
        if (CollectionUtils.isNotEmpty((Collection)steps)) {
            this.echoService.echoMongodbSubmit(EchoSubmitReq.builderStepAnalysis((AthenaMessageEvent)event, (List)steps), event.getUser().getToken(), event.getUser().getTenantId());
        }
    }

    public void executeDebugInfo(AthenaMessageEvent event, Map<String, Object> response, QuerySchemaResDTO responseData) {
        ArrayList debugList = Lists.newArrayList();
        try {
            if (event.isDebug() && StringUtils.equals((CharSequence)"metric", (CharSequence)event.getMethod())) {
                Map contextMap = MapUtils.getMap((Map)MapUtils.getMap(response, (Object)"data"), (Object)"context");
                StringBuilder sqlBuilder = new StringBuilder();
                Object debugObj = contextMap.get("debug");
                if (debugObj instanceof List) {
                    debugList.addAll((Collection)debugObj);
                } else {
                    debugList.add((Map)debugObj);
                }
                if (CollectionUtils.isNotEmpty((Collection)debugList)) {
                    debugList.stream().forEach(debugMap -> {
                        sqlBuilder.append(this.messageUtil.getMessageByLangName("message.adt.metricDebug.message", event.getLang()));
                        sqlBuilder.append(MapUtils.getString((Map)debugMap, (Object)"applicationCode"));
                        sqlBuilder.append("\n");
                        sqlBuilder.append(this.messageUtil.getMessageByLangName("message.adt.metricDebug.sql.message", event.getLang()));
                        sqlBuilder.append(MapUtils.getString((Map)debugMap, (Object)"sql"));
                    });
                }
                if (StringUtils.isNotEmpty((CharSequence)sqlBuilder.toString())) {
                    event.setQuestionUnderstand(sqlBuilder.toString());
                }
                if (CollectionUtils.isNotEmpty((Collection)debugList)) {
                    this.sendMetricCheckMessage((Map)debugList.get(0), event, responseData);
                }
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)TroubleToolCodeEnum.ADT_901_0123.getErrCode(), (String)JsonUtils.objectToString((Object)debugList), (String)TroubleToolCodeEnum.ADT_901_0123.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0123.getSuggestion());
        }
    }

    public void sendMetricCheckMessage(Map<String, Object> contextMap, AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        contextMap.put("messageId", event.getGenerateSerialNo());
        contextMap.put("appCode", event.getAppCode());
        if (CollectionUtils.isNotEmpty((Collection)event.getMetricList())) {
            contextMap.put("metricId", ((Map)event.getMetricList().get(0)).get("metricId"));
        }
        contextMap.put("userLang", event.getLang());
        contextMap.put("debugInfo", responseData.getData().getMetric().getDebug());
        contextMap.put("appName", ((Map)responseData.getData().getMetric().getApplicationList().get(0)).get("appName"));
        String token = event.getUser().getToken();
        String tenantId = event.getUser().getTenantId();
        this.echoService.sendMetricDebugMessage(contextMap, token, tenantId);
    }
}

