/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeSpecialReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.SPECIAL)
public class AgileDataProcessSpecialServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessSpecialServiceImpl.class);
    @Autowired
    private SemcService semcService;
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportService agileReportService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        long getQuerySchemaTook = System.currentTimeMillis();
        Long generateSerialNo = event.getGenerateSerialNo();
        String question2 = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        try {
            Boolean chargingNum = this.echoService.echoChangeCharging(event.getUser().getToken(), event.getUser().getTenantId());
            LogUtils.buildAgileLog((String)"adt", (String)"liteDeduction", (String)"1", (String)event.getUser().getUserId(), (String)JsonUtils.objectToString((Object)chargingNum), (String)"");
            if (chargingNum != null && !chargingNum.booleanValue()) {
                String chargingTitle1 = this.messageUtil.getMessageByLangName("message.echo.charging.fail1", event.getLang());
                String chargingTitle2 = "zh_CN".equals(event.getLang()) ? "\u4f53\u9a8c\u673a\u4f1a\u5df2\u6ee1\uff0c\u6b22\u8fce\u8054\u7cfb\u6211\u4eec\u4e86\u89e3\u66f4\u591a\u4fe1\u606f\uff0c\u9f0e\u6377\u6570\u667a\u611f\u8c22\u60a8\u7684\u5173\u6ce8\u548c\u652f\u6301\uff01\u300d" : "\u9ad4\u9a57\u6a5f\u6703\u5df2\u6eff\uff0c\u6b61\u8fce\u806f\u7e6b\u6211\u5011\u4e86\u89e3\u66f4\u591a\u4fe1\u606f\uff0c\u9f0e\u6377\u6578\u667a\u611f\u8b1d\u60a8\u7684\u95dc\u6ce8\u8207\u652f\u6301\uff01\u300d";
                Object assistantName = event.getMsgExt().get("assistantName");
                String prompt = Objects.isNull(assistantName) ? chargingTitle1.concat(chargingTitle2) : chargingTitle1.concat(String.valueOf(assistantName)).concat(chargingTitle2);
                HashMap<String, String> msgBody = new HashMap<String, String>();
                msgBody.put("prompt", prompt);
                log.info("AgileDataProcessSpecialServiceImpl lang :{},chargingNum is chargingTitle1 :{},chargingTitle2:{}", new Object[]{event.getLang(), chargingTitle1, chargingTitle2});
                this.semcService.sendMessageToGpt(event, msgBody);
                return;
            }
            String snapId = MapUtils.getString((Map)event.getMsgBody(), (Object)"snapshotId", null);
            if (!StringUtils.isEmpty((CharSequence)snapId)) {
                log.info("\u5feb\u7167ID\uff1a{},\u5904\u7406\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)snapId, (Object)TimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
            String combinationQuestion = "";
            for (Map data : responseData.getData().getDataflow()) {
                if (!Objects.isNull(data.get("data")) && "0".equals(String.valueOf(data.get("code")))) {
                    event.setCombinationQuestion(MapUtils.getString((Map)data, (Object)"combinationQuestion"));
                    event.setAppCode(String.valueOf(data.get("applicationCode")));
                    event.setVersion(String.valueOf(data.get("version")));
                    AdeSpecialReqDTO adeSpecialReqDTO = AdeSpecialReqDTO.buildAdeReq((Map)MapUtils.getMap((Map)data, (Object)"data"), (AthenaMessageEvent)event);
                    this.sendMessageToAde(adeSpecialReqDTO, event, combinationQuestion, generateSerialNo);
                    continue;
                }
                HashMap<String, String> msgBody = new HashMap<String, String>();
                msgBody.put("prompt", MapUtils.getString((Map)data, (Object)"data"));
                Object obj = MapUtils.getObject((Map)data, (Object)"sentences", null);
                List sentences = Lists.newArrayList();
                if (obj instanceof Collection) {
                    sentences = CommonUtil.objConvertListString((Object)obj);
                }
                this.semcService.sendMessageToGpt(event, msgBody);
                this.saveAbnormalLog(event, MapUtils.getString((Map)data, (Object)"data"), Integer.valueOf(1), Integer.valueOf(0));
            }
        }
        catch (Exception e) {
            log.error("AgileDataProcessSpecialServiceImpl Exception\uff1a{}", (Object)JsonUtils.objectToString((Object)e));
            HashMap<String, String> msgBody = new HashMap<String, String>();
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            msgBody.put("prompt", tipMessage);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, msgBody);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
    }

    public void sendMessageToAde(AdeSpecialReqDTO adeSpecialReqDTO, AthenaMessageEvent event, String combinationQuestion, Long generateSerialNo) {
        String question2 = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        try {
            HashMap sendMap = Maps.newHashMap();
            Map response = this.adeService.reqSpecialSnapShotData(adeSpecialReqDTO, event);
            if (response == null || MapUtils.getMap((Map)response, (Object)"data") == null) {
                String errorMsg = MapUtils.getString((Map)response, (Object)"msg");
                sendMap.put("prompt", errorMsg);
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            } else {
                AgileDataAnalysisUtils.getTransShowInfo((Map)MapUtils.getMap((Map)response, (Object)"data"), (Map)sendMap);
                String snapshotId = MapUtils.getString((Map)MapUtils.getMap((Map)response, (Object)"data"), (Object)"snapshotId");
                sendMap.put("snapshotId", snapshotId);
            }
            this.agileReportService.executeAgileDataByTokenSize(event.getUser(), event, MapUtils.getMap((Map)response, (Object)"data"));
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
            this.saveQuestionData(MapUtils.getMap((Map)response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
        }
        catch (Exception e) {
            HashMap sendMap = Maps.newHashMap();
            sendMap.put("prompt", e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
        }
    }
}

