/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.pannel;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataDataFlowPanelServiceImpl
extends AbsAgileDataProcess {
    private static final Logger log = LoggerFactory.getLogger(AgileDataDataFlowPanelServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public AgileDataProcessResDTO process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        String question2 = event.getQuestion();
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
        LogDto logDto = new LogDto("\u83b7\u53d6\u610f\u56fe\u8bc6\u522b\u6570\u636e\uff1a" + JsonUtils.objectToString((Object)responseData));
        log.info(logDto.toString());
        ArrayList scenes = Lists.newArrayList();
        try {
            for (Map data : responseData.getData().getDataflow()) {
                if (Objects.nonNull(data.get("code")) && (Integer)data.get("code") == 1) {
                    String kmCode = this.getKmCodeByEventOrSchemaData(event, data);
                    ADEScencDTO adeScencDTO = this.buildCommonAdeScene(event, data);
                    HashMap sceneMap = Maps.newHashMap();
                    sceneMap.put("templateCode", adeScencDTO.getTemplateCode());
                    sceneMap.put("targetId", adeScencDTO.getTarget());
                    sceneMap.put("dimension", adeScencDTO.getDimension());
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u83b7\u53d6KM\u573a\u666f\uff0c\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)sceneMap)});
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u83b7\u53d6KM\u573a\u666f\uff0c\u51fa\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)scenes)});
                    if (StringUtils.isEmpty((CharSequence)kmCode)) {
                        String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
                        this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
                        continue;
                    }
                    adeScencDTO.setSceneCode(kmCode);
                    HashMap recastData = new HashMap();
                    recastData.put(kmCode, data.get("data"));
                    adeScencDTO.setRecast(recastData);
                    Map map = this.sendMessageToAde(event.getUser(), adeScencDTO, event);
                    if (map == null) {
                        return result;
                    }
                    SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)map), SnapShotDTO.class);
                    if (snapShotDTO == null) continue;
                    result = this.agileDataCalculateCostService.combinedBillingCalculationPanel(event, snapShotDTO);
                    this.agileDataCostDetailService.saveAgileDataCostDetail(data, event.getUser(), event.getPtxId(), event.getAppCode(), event.getAppName(), event.getSourceName());
                    continue;
                }
                String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
                this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
            }
        }
        catch (Exception e) {
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
        return result;
    }

    public Map<String, Object> sendMessageToAde(AuthoredUser user, ADEScencDTO adeScencDTO, AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map response = new HashMap();
        try {
            String snapId = MapUtils.getString((Map)event.getMsgBody(), (Object)"snapshotId", null);
            if (StringUtils.isNotEmpty((CharSequence)snapId)) {
                adeScencDTO.setSnapshotId(snapId);
            }
            adeScencDTO.setQuestion(question2);
            response = this.adeService.getRealtimeSnapShotData(user, adeScencDTO, event);
            Map data = MapUtils.getMap(response, (Object)"data");
            if (StringUtils.isNotEmpty((CharSequence)snapId)) {
                log.info("\u5feb\u7167ID\uff1a{},\u5904\u7406\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)snapId, (Object)TimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            if (data == null && MapUtils.getMap(response, (Object)"data") != null) {
                return null;
            }
            event.setAdeScencDTO(adeScencDTO);
            this.saveQuestionData(data, event, question2, combinationQuestion, generateSerialNo);
            this.saveBuiltClassifications(event, response);
        }
        catch (Exception e) {
            log.error("get getPanelByAde error:{}", (Object)e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
        }
        return MapUtils.getMap(response, (Object)"data");
    }
}

