/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.METRIC_DEBUG)
public class SchemaDataProcessMetricDebugServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessMetricDebugServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        String question2 = event.getQuestion();
        QuerySchemaDebugDTO querySchemaDebugDTO = this.assembleQuestionByMsg(question2.trim());
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaMetricDebugReq((AthenaMessageEvent)event, (QuerySchemaDebugDTO)querySchemaDebugDTO);
        try {
            schema = this.chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog((String)"adt", (String)"metric-debug", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"metric-debug", (String)TroubleToolCodeEnum.ADT_901_0109.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0109.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0109.getSuggestion());
        }
        return this.absCheckSchemaResponseData(event, schema);
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        QuerySchemaDebugDTO querySchemaDebugDTO = this.assembleQuestionByMsg(question2.trim());
        return CommonUtil.convertObjectToMap((Object)QuerySchemaReqDTO.builderSchemaMetricDebugReq((AthenaMessageEvent)event, (QuerySchemaDebugDTO)querySchemaDebugDTO));
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaResDTO.class);
        return this.absCheckSchemaResponseData(event, querySchemaResDTO);
    }
}

