/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSendNanaReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.SPECIAL_LITE)
public class SchemaDataProcessSpecialLiteServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessSpecialLiteServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private EchoService echoService;
    public static final String SPECIAL_CODE = "2";
    public static final String SPECIAL_FALSE_CODE = "1";
    public static final String SUCCESS_FALSE_CN = "\u89e3\u6790\u5931\u8d25";
    public static final String SUCCESS_FALSE_TW = "\u89e3\u6790\u5931\u6557";
    public static final String SUCCESS_OTHER_FALSE_CN = "\u90e8\u5206sheet\u89e3\u6790\u5931\u8d25";
    public static final String SUCCESS_OTHER_FALSE_TW = "\u90e8\u5206sheet\u89e3\u6790\u5931\u6557";

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        Map requestParam = this.builderSpecialLiteReq(event);
        QuerySchemaLiteResDTO querySchemaResDTO = this.chatbiService.getQuerySchemaSpecialLite(requestParam, event);
        return this.schemaDataProcessLite(event, querySchemaResDTO);
    }

    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessLite(AthenaMessageEvent event, QuerySchemaLiteResDTO querySchemaResDTO) {
        QuerySchemaResDTO result = new QuerySchemaResDTO();
        if (querySchemaResDTO == null || CollectionUtils.isEmpty((Collection)querySchemaResDTO.getData())) {
            return Pair.of((Object)false, null);
        }
        List dataList = querySchemaResDTO.getData();
        Optional firstDataOptional = dataList.stream().findFirst();
        AgileDataSendNanaReqDTO reqDTO = new AgileDataSendNanaReqDTO();
        if (firstDataOptional.isPresent()) {
            Map firstData = (Map)firstDataOptional.get();
            String codeValue = Optional.ofNullable(String.valueOf(firstData.get("code"))).orElse("");
            if (SPECIAL_CODE.equals(codeValue)) {
                String reply = Optional.ofNullable(String.valueOf(firstData.get("data"))).orElse("");
                HashMap<String, String> msgBody = new HashMap<String, String>();
                msgBody.put("prompt", reply);
                msgBody.put("scrumbiQuestion", event.getQuestion());
                reqDTO.setMsgBody(msgBody);
                this.setAthenaEventMessageType(event, SchemaDataEnum.SPECIAL_LITE.getValue());
                this.echoService.echoMongodbSubmit(EchoSubmitReq.builderSchemaGuidance((AthenaMessageEvent)event, (List)((List)firstData.get("moreTables"))), event.getUser().getToken(), event.getUser().getTenantId());
                this.sendNanaMessageByGetMessage(event, msgBody);
                this.setupResultData(querySchemaResDTO, result);
                return Pair.of((Object)false, (Object)result);
            }
            if (SPECIAL_FALSE_CODE.equals(codeValue)) {
                HashMap msgBody = new HashMap();
                msgBody.put("prompt", ((Map)firstDataOptional.get()).get("data"));
                msgBody.put("scrumbiQuestion", event.getQuestion());
                reqDTO.setMsgBody(msgBody);
                this.setAthenaEventMessageType(event, SchemaDataEnum.SPECIAL_LITE.getValue());
                this.sendNanaMessageByGetMessage(event, msgBody);
                this.setupResultData(querySchemaResDTO, result);
                return Pair.of((Object)false, (Object)result);
            }
            this.setupResultData(querySchemaResDTO, result);
            return Pair.of((Object)true, (Object)result);
        }
        return Pair.of((Object)false, null);
    }

    public Map<String, Object> builderSpecialLiteReq(AthenaMessageEvent event) {
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        if (Objects.nonNull(event.getMsgExt())) {
            requestParam.put("useDemo", event.getMsgExt().get("useDemo"));
            requestParam.put("fileUrl", event.getMsgExt().get("fileUrl"));
            requestParam.put("sessionId", event.getMsgExt().get("sessionId"));
            requestParam.put("tableId", event.getMsgExt().get("tableId"));
            requestParam.put("tableName", event.getMsgExt().get("tableName"));
            requestParam.put("asaCode", event.getMsgExt().get("asaCode"));
        }
        if (Objects.nonNull(event.getMsgExt()) && Objects.nonNull(event.getMsgExt().get("tableId"))) {
            requestParam.put("multiDialogue", false);
        } else {
            requestParam.put("multiDialogue", true);
        }
        requestParam.put("message", event.getQuestion());
        return requestParam;
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        return this.builderSpecialLiteReq(event);
    }

    public void setupResultData(QuerySchemaLiteResDTO querySchemaResDTO, QuerySchemaResDTO result) {
        QuerySchemaDataDTO data = new QuerySchemaDataDTO();
        data.setDataflow(querySchemaResDTO.getData());
        data.setMethod(SchemaDataEnum.SPECIAL.getCode());
        result.setRoute(SchemaDataEnum.SPECIAL.getCode());
        result.setMsg(querySchemaResDTO.getMsg());
        result.setCode(querySchemaResDTO.getCode());
        result.setData(data);
    }

    public AgileDataSpecialUploadResDTO liteUploadProcessMessage(AgileDataSpecialUploadReqDTO req, AuthoredUser user) {
        AgileDataSpecialUploadResDTO resDTO = new AgileDataSpecialUploadResDTO();
        req.setUserId(user.getUserId());
        req.setTenantId(user.getTenantId());
        String userLangName = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        req.setLocale(StringUtils.isEmpty((CharSequence)userLangName) ? "zh_CN" : userLangName);
        SchemaPushReportResDTO result = this.chatbiService.schemaPushReport(user, req);
        if (result != null && result.getData() != null) {
            int code = result.getData().getCode();
            this.setMsgByCode(resDTO, userLangName, code);
            BeanUtils.copyProperties((Object)result.getData(), (Object)resDTO);
            String prompt = result.getData().getSentenceTitle();
            if (StringUtils.isEmpty((CharSequence)prompt)) {
                prompt = this.messageUtil.getMessageByLangName("message.adt.lite.message", req.getLocale());
            }
            resDTO.setPrompt(prompt);
            resDTO.setSendNana(true);
            resDTO.setMultiDialogue(false);
        } else {
            resDTO.setMsg(result != null ? result.getMsg() : "");
            resDTO.setSuccess(false);
        }
        return resDTO;
    }

    private void setMsgByCode(AgileDataSpecialUploadResDTO resDTO, String userLangName, int code) {
        if (code == 0) {
            resDTO.setSuccess(true);
            resDTO.setMsg("");
        } else if (code == 1) {
            resDTO.setSuccess(false);
            if ("zh_CN".equals(userLangName)) {
                resDTO.setMsg(SUCCESS_FALSE_CN);
            } else {
                resDTO.setMsg(SUCCESS_FALSE_TW);
            }
        } else if (code == 2) {
            resDTO.setSuccess(true);
            if ("zh_CN".equals(userLangName)) {
                resDTO.setMsg(SUCCESS_OTHER_FALSE_CN);
            } else {
                resDTO.setMsg(SUCCESS_OTHER_FALSE_TW);
            }
        } else {
            resDTO.setMsg("");
            resDTO.setSuccess(false);
        }
    }

    public void sendNanaMessage(AgileDataSendNanaReqDTO req, AuthoredUser user) {
        Map msgBody = req.getMsgBody();
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageDTO.setMsgBody(msgBody);
        sendMessageDTO.setUserId(user.getUserId());
        sendMessageDTO.setSkillType(SPECIAL_FALSE_CODE);
        sendMessageDTO.setMsgType("CUSTOM");
        log.info("Sending Message to  B\u5a1c sendMessageDTO :{}", (Object)JsonUtils.objectToString((Object)sendMessageDTO));
        this.semcService.sendMessage(sendMessageDTO, user.getToken(), user.getTenantId());
    }

    public void sendNanaMessageByGetMessage(AthenaMessageEvent event, Map<String, Object> msgBody) {
        this.semcService.sendMessageToGpt(event, msgBody);
        this.saveAbnormalLog(event, String.valueOf(msgBody.get("prompt")), Integer.valueOf(1), Integer.valueOf(0));
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaLiteResDTO querySchemaResDTO = (QuerySchemaLiteResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaLiteResDTO.class);
        return this.schemaDataProcessLite(event, querySchemaResDTO);
    }
}

