/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.screenModel;

import com.digiwin.athena.adt.agileReport.service.AgileDataScreenModelService;
import com.digiwin.athena.adt.domain.dto.AgileDataScreenModelDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class AgileDataScreenModelImpl
implements AgileDataScreenModelService {
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_screen_model";

    public Boolean createAgileDataScreenModel(AuthoredUser authoredUser, AgileDataScreenModelDTO agileDataScreenModel) {
        String modelId = agileDataScreenModel.getModelId();
        Integer version = agileDataScreenModel.getVersion();
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"modelId").is((Object)modelId).and("version").is((Object)version));
        AgileDataScreenModelDTO agileDataModel = (AgileDataScreenModelDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataScreenModelDTO.class, MONGODB_COLLECTION_NAME);
        if (agileDataModel == null) {
            this.mongoAgileDataPageViewTemplate.insert((Object)agileDataScreenModel, MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("models", (Object)agileDataScreenModel.getModels());
            this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataScreenModelDTO.class, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public AgileDataScreenModelDTO queryAgileDataScreenModel(AuthoredUser authoredUser, String modelId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"modelId").is((Object)modelId).and("version").is((Object)1));
        AgileDataScreenModelDTO agileDataModelDTO = (AgileDataScreenModelDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataScreenModelDTO.class, MONGODB_COLLECTION_NAME);
        return agileDataModelDTO;
    }
}

