/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.snap;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataMoreActionDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileTransDataDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageResDTO;
import com.digiwin.athena.adt.agileReport.dao.SnapShotDataMapper;
import com.digiwin.athena.adt.agileReport.service.AgileApcDataService;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.SDScencDTO;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.AamDataResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PageReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneUserCommonDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileApcDataEocMap;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.eoc.EocService;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDeptEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDirectEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDutyEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActionParameterDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmUserResponseDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SnapShotDataServiceImpl
implements SnapShotDataService {
    private static final Logger log = LoggerFactory.getLogger(SnapShotDataServiceImpl.class);
    @Autowired
    private SnapShotDataMapper snapShotDataMapper;
    @Resource
    private ADEService adeService;
    @Autowired
    private EocService eocService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AgileApcDataService agileApcDataService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private SnapShotDataService snapShotDataService;
    private static final String TENANT_ID = "tenantId";
    private static final String PERFORMER_ID = "performerId";
    private static final String SNAPSHOT_ID = "snapshotId";
    private static final String CODE = "code";

    public void saveSnapShotData(SnapShotDTO snapShotDTO, String uploadFileId, List<TmUserResponseDto> userResponses) {
        Objects.requireNonNull(snapShotDTO, "\u4f20\u5165\u7684\u5b9e\u4f53\u7c7b\u4e3a\u7a7a\uff01");
        ArrayList<SnapData> snapDataList = new ArrayList<SnapData>();
        String snapShotId = snapShotDTO.getSnapshotId();
        String detectionId = snapShotDTO.getContext().getBizParams().getMonitor().getMonitorRuleId();
        String tenantId = snapShotDTO.getContext().getBizParams().getTenantId();
        String code = snapShotDTO.getContext().getBizParams().getSceneCode();
        if (StringUtils.isEmpty((CharSequence)code)) {
            code = snapShotDTO.getContext().getScene().getCode();
        }
        String title = "";
        if (MapUtils.isNotEmpty((Map)snapShotDTO.getContext().getBizParams().getQuerySchema())) {
            title = MapUtils.getString((Map)snapShotDTO.getContext().getBizParams().getQuerySchema(), (Object)"sceneTitle");
        }
        Map map = snapShotDTO.getContext().getBizParams().getParam();
        log.info("snapShotDTO.getContext().getBizParams().getParam() : {}", (Object)JsonUtils.objectToString((Object)map));
        int defaultValue = StringUtils.equals((CharSequence)"instant", (CharSequence)snapShotDTO.getContext().getBizParams().getRequestType()) ? 1 : 0;
        int entry = MapUtils.getIntValue((Map)map, (Object)"type", (int)defaultValue);
        String messageType = MapUtils.getString((Map)map, (Object)"messageType");
        LocalDateTime requestTime = snapShotDTO.getContext().getBizParams().getRequestTime();
        for (TmUserResponseDto userResponse : userResponses) {
            SnapData snapData = new SnapData();
            snapData.setSnapshotId(snapShotId);
            snapData.setPerformerId(userResponse.getUserId());
            snapData.setTenantId(tenantId);
            snapData.setUserName(userResponse.getUserName());
            snapData.setCode(code);
            snapData.setDetectionId(detectionId);
            snapData.setRequestTime(requestTime);
            snapData.setDmcId(uploadFileId);
            snapData.setEntry(Integer.valueOf(entry));
            snapData.setMessageType(messageType);
            snapData.setTitle(title);
            snapData.setReadCount(Integer.valueOf(0));
            snapData.setStatus(Integer.valueOf(0));
            snapData.setCreateDate(LocalDateTime.now());
            if (MapUtils.isNotEmpty((Map)snapShotDTO.getContext().getBizParams().getQuerySchema())) {
                snapData.setQueryType("1");
            } else {
                snapData.setQueryType("0");
            }
            snapDataList.add(snapData);
        }
        if (!snapDataList.isEmpty()) {
            this.snapShotDataMapper.insertBatchSomeColumn(snapDataList);
        }
    }

    public List<TmUserResponseDto> getUserResponse(SnapShotDTO snapShotDTO) {
        ArrayList<TmUserResponseDto> retList = new ArrayList<TmUserResponseDto>();
        List whoList = snapShotDTO.getContext().getScene().getWho();
        if (whoList == null || whoList.isEmpty()) {
            throw ErrorCodeEnum.WHO_IS_EMPTY.getBusinessException();
        }
        for (SceneUserCommonDTO sceneCommonDTO : whoList) {
            String type = sceneCommonDTO.getType();
            List valueList = sceneCommonDTO.getValue().stream().map(userMap -> MapUtils.getString((Map)userMap, (Object)"id")).collect(Collectors.toList());
            this.processValueByType(type, valueList, retList);
        }
        return retList;
    }

    private void processValueByType(String type, List<String> valueList, List<TmUserResponseDto> retList) {
        for (String value : valueList) {
            switch (type) {
                case "user": {
                    EocEmployeeDTO userDto = this.eocService.getEmployeeByUserId(value);
                    if (userDto == null) break;
                    retList.addAll(this.convertFromEmployee(userDto));
                    break;
                }
                case "deptDirector": {
                    EocDirectEmployeeDTO directorDto = this.eocService.getDirectorEmployee(value);
                    if (directorDto == null) break;
                    retList.addAll(this.convertFromDirector(directorDto));
                    break;
                }
                case "duty": {
                    List dutyDtoList = this.eocService.getDutyEmployees(value, null, null);
                    if (dutyDtoList == null) break;
                    retList.addAll(this.convertFromDuty(dutyDtoList));
                    break;
                }
                case "deptUser": {
                    List deptDtoList = this.eocService.getDepartEmployees(value);
                    if (deptDtoList == null) break;
                    retList.addAll(this.convertFromDept(deptDtoList));
                    break;
                }
            }
        }
    }

    public List<SnapData> getSnapShotDataList(String tenantId, String userId, PageReqDTO pageReqDTO) {
        List dataList;
        QueryWrapper queryWrapper = new QueryWrapper();
        Page page = new Page();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)tenantId)).eq((Object)PERFORMER_ID, (Object)userId)).eq((Object)"entry", (Object)"0")).orderByDesc((Object)"requestTime");
        if (pageReqDTO.getIsRead() != null) {
            if (pageReqDTO.getIsRead().booleanValue()) {
                queryWrapper.ne((Object)"readCount", (Object)0);
            } else {
                queryWrapper.eq((Object)"readCount", (Object)0);
            }
        }
        if (pageReqDTO.getCurrentPage() != null && pageReqDTO.getPageSize() != null) {
            page.setCurrent((long)pageReqDTO.getCurrentPage().intValue());
            page.setSize((long)pageReqDTO.getPageSize().intValue());
            page = (Page)this.snapShotDataMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            dataList = page.getRecords();
        } else {
            dataList = this.snapShotDataMapper.selectList((Wrapper)queryWrapper);
        }
        return dataList;
    }

    public SnapData getSnapDataBySnapshotId(String tenantId, String userId, String snapshotId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)tenantId)).eq((Object)PERFORMER_ID, (Object)userId)).eq((Object)SNAPSHOT_ID, (Object)snapshotId);
        return (SnapData)this.snapShotDataMapper.selectOne((Wrapper)queryWrapper);
    }

    public SnapDataInfoDTO getSnapDataInfoBySnapshotId(String tenantId, String userId, String snapshotId) {
        SnapDataInfoDTO snapDataInfoDTO = new SnapDataInfoDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)tenantId)).eq((Object)PERFORMER_ID, (Object)userId)).eq((Object)SNAPSHOT_ID, (Object)snapshotId);
        SnapData snapData = (SnapData)this.snapShotDataMapper.selectOne((Wrapper)queryWrapper);
        if (snapData == null) {
            return snapDataInfoDTO;
        }
        return this.getSnapDataInfo(snapData);
    }

    public SnapDataInfoDTO getScreenSnapData(String tenantId, String userId, String sceneCode) {
        SnapDataInfoDTO snapDataInfoDTO = new SnapDataInfoDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)tenantId)).eq((Object)PERFORMER_ID, (Object)userId)).eq((Object)CODE, (Object)sceneCode);
        queryWrapper.orderByDesc((Object)"requestTime");
        queryWrapper.last("LIMIT 1");
        SnapData snapData = (SnapData)this.snapShotDataMapper.selectOne((Wrapper)queryWrapper);
        if (snapData == null) {
            return snapDataInfoDTO;
        }
        snapDataInfoDTO = this.getSnapDataInfo(snapData);
        if (StringUtils.isEmpty((CharSequence)snapDataInfoDTO.getSnapData().getQueryType())) {
            snapDataInfoDTO.getSnapData().setQueryType("0");
        }
        return snapDataInfoDTO;
    }

    public SnapDataInfoDTO getScreenSnapSyncData(AuthoredUser user, AgileDataMoreActionDTO agileDataMoreActionDTO, String local) {
        SnapDataInfoDTO snapDataInfoDTO = new SnapDataInfoDTO();
        AthenaApcMessageReqDTO athenaApcMessageReqDTO = new AthenaApcMessageReqDTO();
        athenaApcMessageReqDTO.setSceneCode(agileDataMoreActionDTO.getSceneCode());
        AgileApcDataEocMap eocMap = new AgileApcDataEocMap();
        eocMap.setEocCompanyId(MapUtils.getString((Map)agileDataMoreActionDTO.getEocMap(), (Object)"eocCompanyId"));
        eocMap.setEocSiteId(MapUtils.getString((Map)agileDataMoreActionDTO.getEocMap(), (Object)"eocSiteId"));
        athenaApcMessageReqDTO.setEocMaps((List)Lists.newArrayList((Object[])new AgileApcDataEocMap[]{eocMap}));
        athenaApcMessageReqDTO.setRequestType(agileDataMoreActionDTO.getRequestType());
        athenaApcMessageReqDTO.setFixedParams(agileDataMoreActionDTO.getFixedParams());
        AthenaApcMessageResDTO data = (AthenaApcMessageResDTO)this.agileApcDataService.processMessage(null, athenaApcMessageReqDTO, user, local);
        if (data == null || data.isError().booleanValue()) {
            log.error("\u83b7\u53d6\u5927\u5c4f\u4fe1\u606f\u5931\u8d25");
            return snapDataInfoDTO;
        }
        SnapDataDTO snapDataDTO = new SnapDataDTO();
        snapDataDTO.setQueryType("0");
        snapDataDTO.setCode(data.getSnapShotDTO().getContext().getBizParams().getSceneCode());
        snapDataDTO.setPerformerId(user.getUserId());
        snapDataDTO.setTenantId(user.getTenantId());
        snapDataInfoDTO.setSnapData(snapDataDTO);
        this.getSnapShotDetail(snapDataInfoDTO, data.getSnapShotDTO());
        if (StringUtils.isEmpty((CharSequence)snapDataInfoDTO.getSnapData().getQueryType())) {
            snapDataInfoDTO.getSnapData().setQueryType("0");
        }
        return snapDataInfoDTO;
    }

    private SnapDataInfoDTO getSnapDataInfo(SnapData snapData) {
        SnapDataInfoDTO snapDataInfoDTO = new SnapDataInfoDTO();
        if (snapData == null) {
            return snapDataInfoDTO;
        }
        SnapDataDTO snapDataDTO = new SnapDataDTO();
        BeanUtils.copyProperties((Object)snapData, (Object)snapDataDTO);
        snapDataInfoDTO.setSnapData(snapDataDTO);
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(snapData.getDmcId());
        if (snapShotDTO == null) {
            log.error("\u83b7\u53d6DMC\u6587\u4ef6\u5931\u8d25");
            return snapDataInfoDTO;
        }
        this.getSnapShotDetail(snapDataInfoDTO, snapShotDTO);
        return snapDataInfoDTO;
    }

    private void getSnapShotDetail(SnapDataInfoDTO snapDataInfoDTO, SnapShotDTO snapShotDTO) {
        HashMap<String, List> listMap = new HashMap<String, List>();
        if (MapUtils.isNotEmpty((Map)snapShotDTO.getContext().getBizParams().getQuerySchema())) {
            snapDataInfoDTO.setQuerySchema(snapShotDTO.getContext().getBizParams().getQuerySchema());
            for (PullDataDTO pullDataDTO : snapShotDTO.getContext().getPullData()) {
                listMap.computeIfAbsent(pullDataDTO.getModelId(), k -> new ArrayList()).add(pullDataDTO);
            }
        } else {
            snapDataInfoDTO.setBackRecast(snapShotDTO.getContext().getBizParams().getBackRecast());
            for (PullDataDTO pullDataDTO : snapShotDTO.getContext().getPullData()) {
                listMap.computeIfAbsent(pullDataDTO.getActionId(), k -> new ArrayList()).add(pullDataDTO);
            }
        }
        snapDataInfoDTO.setShowDefine(snapShotDTO.getContext().getBizParams().getShowDefine());
        snapDataInfoDTO.setLink(this.getLink(snapShotDTO));
        snapDataInfoDTO.setPageData(listMap);
        snapDataInfoDTO.getSnapData().setDimensionInterval(snapShotDTO.getContext().getBizParams().getDimensionInterval());
        snapDataInfoDTO.getSnapData().setMessageId(snapShotDTO.getContext().getBizParams().getMessageId());
        snapDataInfoDTO.getSnapData().setDimensionCnt(snapShotDTO.getContext().getBizParams().getDimensionCnt());
        if (MapUtils.isNotEmpty((Map)snapShotDTO.getContext().getBizParams().getShowDefine()) && snapShotDTO.getContext().getBizParams().getShowDefine().containsKey("aliasGrain")) {
            String grainJsonStr = JsonUtils.objectToString(snapShotDTO.getContext().getBizParams().getShowDefine().get("aliasGrain"));
            snapDataInfoDTO.getSnapData().setAliasGrain(JsonUtils.jsonToListObject((String)grainJsonStr, SchemaMetricShowDefine.AliasGrain.class));
        }
    }

    private String getLink(SnapShotDTO snapShotDTO) {
        String requestType = snapShotDTO.getContext().getBizParams().getRequestType();
        if (StringUtils.isNotEmpty((CharSequence)requestType) && StringUtils.equals((CharSequence)"metricInstant", (CharSequence)requestType)) {
            return "2";
        }
        String method = snapShotDTO.getContext().getBizParams().getMethod();
        if (StringUtils.isNotEmpty((CharSequence)method) && StringUtils.equals((CharSequence)"metric", (CharSequence)method)) {
            return "2";
        }
        if (StringUtils.isNotEmpty((CharSequence)method) && StringUtils.equals((CharSequence)"dataset", (CharSequence)method)) {
            return "2";
        }
        return "1";
    }

    public List<Map<String, Object>> getSnapShotDetail(AgileReportDetailParamsDTO agileReportDetailParamsDTO, AuthoredUser user) {
        String dmcId = this.getDmcId(agileReportDetailParamsDTO.getReportId(), user.getTenantId(), user.getUserId());
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            return Lists.newArrayList();
        }
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(dmcId);
        if (snapShotDTO == null) {
            return Lists.newArrayList();
        }
        return this.getAgileData(snapShotDTO, agileReportDetailParamsDTO);
    }

    public Map<String, Object> getSnapPageShotDetail(AgileReportDetailParamsDTO agileReportDetailParamsDTO, AuthoredUser user) {
        String dmcId = this.getDmcId(agileReportDetailParamsDTO.getSnapshotId(), user.getTenantId(), user.getUserId());
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            return Maps.newHashMap();
        }
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(dmcId);
        if (snapShotDTO == null) {
            return Maps.newHashMap();
        }
        return this.getPageAgileData(snapShotDTO, agileReportDetailParamsDTO);
    }

    private List<Map<String, Object>> getAgileData(SnapShotDTO snapShotDTO, AgileReportDetailParamsDTO agileReportDetailParamsDTO) {
        ArrayList dataList = Lists.newArrayList();
        HashMap<String, List> listMap = new HashMap<String, List>();
        for (PullDataDTO pullDataDTO : snapShotDTO.getContext().getPullData()) {
            listMap.computeIfAbsent(pullDataDTO.getActionId(), k -> new ArrayList()).add(pullDataDTO);
        }
        for (String key : listMap.keySet()) {
            HashMap map = Maps.newHashMap();
            List lists = (List)listMap.get(key);
            ArrayList toList = Lists.newArrayList();
            lists.stream().forEach(data -> {
                List templist = (List)MapUtils.getObject((Map)data.getData(), (Object)"data");
                templist.stream().forEach(monthData -> {
                    if (this.containsData(agileReportDetailParamsDTO, monthData)) {
                        toList.add(monthData);
                    }
                });
                map.put(key, toList);
                dataList.add(map);
            });
        }
        return dataList;
    }

    private Map<String, Object> getPageAgileData(SnapShotDTO snapShotDTO, AgileReportDetailParamsDTO agileReportDetailParamsDTO) {
        HashMap pageResult = Maps.newHashMap();
        ArrayList dataList = Lists.newArrayList();
        HashMap<String, List> listMap = new HashMap<String, List>();
        for (PullDataDTO pullDataDTO : snapShotDTO.getContext().getPullData()) {
            listMap.computeIfAbsent(pullDataDTO.getActionId(), k -> new ArrayList()).add(pullDataDTO);
        }
        HashMap map = Maps.newHashMap();
        List lists = (List)listMap.get(agileReportDetailParamsDTO.getActionId());
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            ArrayList toList = Lists.newArrayList();
            lists.stream().forEach(data -> {
                List templist = (List)MapUtils.getObject((Map)data.getData(), (Object)"data");
                templist.stream().forEach(monthData -> {
                    if (this.containsData(agileReportDetailParamsDTO, monthData)) {
                        toList.add(monthData);
                    }
                });
            });
            pageResult.put(agileReportDetailParamsDTO.getActionId(), toList);
            if (agileReportDetailParamsDTO.getPageSize() != null && agileReportDetailParamsDTO.getPageNo() != null) {
                PageInfo pageInfo = this.listToPage((List)toList, agileReportDetailParamsDTO.getPageNo().intValue(), agileReportDetailParamsDTO.getPageSize().intValue());
                map.put(agileReportDetailParamsDTO.getActionId(), pageInfo.getList());
                dataList.add(map);
                pageResult.put(agileReportDetailParamsDTO.getActionId(), dataList);
                pageResult.put("has_next", pageInfo.isHasNextPage());
                pageResult.put("total_results", pageInfo.getTotal());
            }
        }
        return pageResult;
    }

    public PageInfo listToPage(List<Object> recordList, int page, int pagesize) {
        int total = recordList.size();
        long pageNum = (long)page - 1L;
        long pageSize = pagesize;
        List pageList = recordList.stream().skip(pageNum * pageSize).limit(pagesize).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(pageList);
        pageInfo.setPageNum(page);
        pageInfo.setPageSize(pagesize);
        pageInfo.setList(pageList);
        pageInfo.setPages((total + pagesize - 1) / pagesize);
        pageInfo.setTotal((long)total);
        return pageInfo;
    }

    public List<Map<String, Object>> getScencDetail(SDScencDTO sdScencDTO, AuthoredUser user) {
        SnapShotDTO snapShotDTO = this.adeService.getSnapShotData(sdScencDTO);
        return this.getAgileData(snapShotDTO, new AgileReportDetailParamsDTO());
    }

    private boolean containsData(AgileReportDetailParamsDTO agileReportDetailParamsDTO, Object responseDataDTO) {
        boolean checkResult = true;
        if (CollectionUtils.isEmpty((Collection)agileReportDetailParamsDTO.getParams())) {
            return checkResult;
        }
        Map pullMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)responseDataDTO), Map.class);
        for (TmActionParameterDTO tmActionParameterDTO : agileReportDetailParamsDTO.getParams()) {
            if (pullMap.containsKey(tmActionParameterDTO.getName()) || Objects.equals(tmActionParameterDTO.getValue(), pullMap.get(tmActionParameterDTO.getName()))) continue;
            checkResult = false;
        }
        return checkResult;
    }

    public List<SnapData> getSnapShotUserList(String snapshotId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)SNAPSHOT_ID, (Object)snapshotId);
        return this.snapShotDataMapper.selectList((Wrapper)queryWrapper);
    }

    public SnapShotDTO getSnapShotData(String snapshotId, String tenantId, String userId) {
        String dmcId = this.getDmcId(snapshotId, tenantId, userId);
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            throw ErrorCodeEnum.DMCID_CAN_NOT_FIND.getBusinessExceptionWithArgs(new Object[]{snapshotId, tenantId, userId});
        }
        return this.dmcService.getAgileData(dmcId);
    }

    public String getDmcId(String snapshotId, String tenantId, String userId) {
        return this.snapShotDataMapper.getDmcId(snapshotId, tenantId, userId);
    }

    public void updateReadCount(String snapshotId, String tenantId, String userId) {
        this.snapShotDataMapper.updateReadCount(snapshotId, tenantId, userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSnap(String snapshotId, String tenantId, String userId) {
        try {
            SnapData snapData = this.getSnapDataBySnapshotId(tenantId, userId, snapshotId);
            if (null == snapData) {
                throw ErrorCodeEnum.DELETE_SNAP_IS_EMPTY.getBusinessException();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)SNAPSHOT_ID, (Object)snapshotId)).eq((Object)TENANT_ID, (Object)tenantId)).eq((Object)PERFORMER_ID, (Object)userId);
            this.snapShotDataMapper.delete((Wrapper)queryWrapper);
            this.dmcService.deleteAgileData(snapData.getDmcId());
        }
        catch (Exception e) {
            throw BusinessException.create((String)("\u5220\u9664\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a " + e.getMessage()));
        }
    }

    public Integer updateSnapsStatue(String snapshotId, String tenantId, String userId) {
        return this.snapShotDataMapper.updateSnapsStatue(snapshotId, tenantId, userId);
    }

    private List<TmUserResponseDto> convertFromEmployee(EocEmployeeDTO employeeDTO) {
        ArrayList<TmUserResponseDto> retList = new ArrayList<TmUserResponseDto>();
        TmUserResponseDto dto = new TmUserResponseDto();
        if (null != employeeDTO.getDepts() && !employeeDTO.getDepts().isEmpty()) {
            dto.setDeptId(((EocEmployeeDTO.EocEmployeeDepartDTO)employeeDTO.getDepts().get(0)).getId());
            dto.setDeptName(((EocEmployeeDTO.EocEmployeeDepartDTO)employeeDTO.getDepts().get(0)).getName());
        }
        dto.setEmpId(employeeDTO.getId());
        dto.setEmpName(employeeDTO.getName());
        if (null != employeeDTO.getUser()) {
            dto.setUserId(employeeDTO.getUser().getId());
            dto.setUserName(employeeDTO.getUser().getName());
        }
        retList.add(dto);
        return retList;
    }

    private List<TmUserResponseDto> convertFromDirector(EocDirectEmployeeDTO directorDto) {
        ArrayList<TmUserResponseDto> retList = new ArrayList<TmUserResponseDto>();
        TmUserResponseDto dto = new TmUserResponseDto();
        dto.setDeptId(directorDto.getDeptId());
        dto.setDeptName(directorDto.getDeptName());
        dto.setEmpId(directorDto.getId());
        dto.setEmpName(directorDto.getName());
        dto.setUserId(directorDto.getUserId());
        dto.setUserName(directorDto.getUserName());
        retList.add(dto);
        return retList;
    }

    private List<TmUserResponseDto> convertFromDuty(List<EocDutyEmployeeDTO> dutyDtoList) {
        ArrayList<TmUserResponseDto> retList = new ArrayList<TmUserResponseDto>();
        for (EocDutyEmployeeDTO tempDto : dutyDtoList) {
            TmUserResponseDto dto = new TmUserResponseDto();
            dto.setDeptId(tempDto.getDeptId());
            dto.setDeptName(tempDto.getDeptName());
            dto.setEmpId(tempDto.getId());
            dto.setEmpName(tempDto.getName());
            dto.setUserId(tempDto.getUserId());
            dto.setUserName(tempDto.getUserName());
            retList.add(dto);
        }
        return retList;
    }

    private List<TmUserResponseDto> convertFromDept(List<EocDeptEmployeeDTO> deptDtoList) {
        ArrayList<TmUserResponseDto> retList = new ArrayList<TmUserResponseDto>();
        for (EocDeptEmployeeDTO tempDto : deptDtoList) {
            TmUserResponseDto dto = new TmUserResponseDto();
            dto.setDeptId(tempDto.getDeptId());
            dto.setDeptName(tempDto.getDeptName());
            dto.setEmpId(tempDto.getEmpId());
            dto.setEmpName(tempDto.getEmpName());
            dto.setUserId(tempDto.getUserId());
            dto.setUserName(tempDto.getUserName());
            retList.add(dto);
        }
        return retList;
    }

    public AamDataResDTO getAamDataBySnapshotId(String snapshotId, String tenantId, String userId) {
        AamDataResDTO resDTO = new AamDataResDTO();
        String dmcId = this.getDmcId(snapshotId, tenantId, userId);
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            return resDTO;
        }
        log.info("adt getAamDataBySnapshotId snapshotId{},dmcId{}:", (Object)snapshotId, (Object)dmcId);
        String redisSceneCode = (String)this.stringRedisTemplate.opsForValue().get((Object)snapshotId);
        if (StringUtils.isNotEmpty((CharSequence)redisSceneCode)) {
            resDTO.setSceneCode(redisSceneCode);
            return resDTO;
        }
        return AamDataResDTO.builderAamDataBySnapShotDTO((SnapShotDTO)this.dmcService.getAgileData(dmcId), (StringRedisTemplate)this.stringRedisTemplate);
    }

    public Map<String, Object> getThirdPartyAgileData(String snapshotId, AuthoredUser authoredUser) {
        HashMap<String, Object> snapshotResult = new HashMap<String, Object>();
        String dmcId = this.getDmcId(snapshotId, authoredUser.getTenantId(), authoredUser.getUserId());
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            return snapshotResult;
        }
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(dmcId);
        if (snapShotDTO != null) {
            String method = snapShotDTO.getContext().getBizParams().getMethod();
            Object undeleteTable = snapShotDTO.getContext().getBizParams().getParam().get("undeletable");
            String question2 = snapShotDTO.getContext().getBizParams().getQuestion();
            if (CollectionUtils.isNotEmpty((Collection)snapShotDTO.getContext().getPullData())) {
                List metricList = ((PullDataDTO)snapShotDTO.getContext().getPullData().get(0)).getMetricList();
                ArrayList<String> metricIdList = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty((Collection)metricList)) {
                    for (Map map : metricList) {
                        Object metricIdObj;
                        if (!map.containsKey("metricId") || !((metricIdObj = map.get("metricId")) instanceof String)) continue;
                        metricIdList.add((String)metricIdObj);
                    }
                }
                snapshotResult.put("metricIdList", metricIdList);
            }
            snapshotResult.put("method", method);
            snapshotResult.put("question", question2);
            snapshotResult.put("undeletable", !Objects.isNull(undeleteTable) && (Boolean)undeleteTable != false);
        }
        return snapshotResult;
    }

    public SnapDataInfoDTO transAgileData(AgileTransDataDTO agileTransDataDTO, AuthoredUser authoredUser, String lang) {
        List showTypeList;
        Map bizParams;
        Map showDefine;
        SnapDataInfoDTO snapDataInfoDTO = new SnapDataInfoDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)TENANT_ID, (Object)authoredUser.getTenantId())).eq((Object)PERFORMER_ID, (Object)authoredUser.getUserId())).eq((Object)SNAPSHOT_ID, (Object)agileTransDataDTO.getSnapshotId());
        SnapData snapData = (SnapData)this.snapShotDataMapper.selectOne((Wrapper)queryWrapper);
        if (snapData == null) {
            log.error("\u65e0\u5feb\u7167\u4fe1\u606f");
            throw BusinessException.create((String)ErrorCodeEnum.TRANS_DATA_ERROR.getErrCode(), (String)this.messageUtil.getMessage("agileData.getTransData.error.info"));
        }
        SnapDataDTO snapDataDTO = new SnapDataDTO();
        BeanUtils.copyProperties((Object)snapData, (Object)snapDataDTO);
        snapDataInfoDTO.setSnapData(snapDataDTO);
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(snapData.getDmcId());
        if (snapShotDTO == null) {
            log.error("\u83b7\u53d6DMC\u6587\u4ef6\u5931\u8d25");
            throw BusinessException.create((String)ErrorCodeEnum.TRANS_DATA_ERROR.getErrCode(), (String)this.messageUtil.getMessage("agileData.getTransData.error.info"));
        }
        String originalId = snapShotDTO.getContext().getBizParams().getOriginalSnapshotDataFileId();
        Map transData = StringUtils.isEmpty((CharSequence)originalId) ? this.adeService.transPresentAgileData(authoredUser, agileTransDataDTO.getTransId(), null, snapShotDTO, lang) : this.adeService.transPresentAgileData(authoredUser, agileTransDataDTO.getTransId(), originalId, null, lang);
        if (transData == null) {
            log.error("\u8f6c\u6362\u539f\u59cb\u6570\u636e\u5931\u8d25");
            throw BusinessException.create((String)ErrorCodeEnum.TRANS_DATA_ERROR.getErrCode(), (String)this.messageUtil.getMessage("agileData.getTransData.error.info"));
        }
        log.info("\u8f6c\u6362\u540e\u7684\u5feb\u7167\u6570\u636e\uff1a{}", (Object)JsonUtils.objectToString((Object)transData));
        Map data = MapUtils.getMap((Map)transData, (Object)"data");
        Map context = MapUtils.getMap((Map)data, (Object)"context");
        List pullData = (List)MapUtils.getObject((Map)context, (Object)"pullData");
        if (CollectionUtils.isNotEmpty((Collection)pullData)) {
            ArrayList snapPullData = Lists.newArrayList();
            pullData.stream().forEach(transAgileData -> {
                PullDataDTO pullDataDTO = new PullDataDTO();
                pullDataDTO.setActionId(MapUtils.getString((Map)transAgileData, (Object)"actionId"));
                pullDataDTO.setModelId(MapUtils.getString((Map)transAgileData, (Object)"modelId"));
                pullDataDTO.setSceneCode(MapUtils.getString((Map)transAgileData, (Object)"sceneCode"));
                pullDataDTO.setStartTime(MapUtils.getString((Map)transAgileData, (Object)"startTime"));
                pullDataDTO.setEndTime(MapUtils.getString((Map)transAgileData, (Object)"endTime"));
                pullDataDTO.setData(MapUtils.getMap((Map)transAgileData, (Object)"data"));
                pullDataDTO.setMetadata(MapUtils.getMap((Map)transAgileData, (Object)"metadata"));
                pullDataDTO.setDataTag(MapUtils.getMap((Map)transAgileData, (Object)"dataTag"));
                pullDataDTO.setMetricList((List)MapUtils.getObject((Map)transAgileData, (Object)"metricList"));
                snapPullData.add(pullDataDTO);
            });
            snapShotDTO.getContext().setPullData((List)snapPullData);
        }
        if (MapUtils.isNotEmpty((Map)(showDefine = (Map)MapUtils.getObject((Map)(bizParams = MapUtils.getMap((Map)context, (Object)"bizParams")), (Object)"showDefine"))) && CollectionUtils.isNotEmpty((Collection)(showTypeList = (List)MapUtils.getObject((Map)showDefine, (Object)"showType")))) {
            Map showType = (Map)showTypeList.get(0);
            List typeList = (List)showType.get("type");
            if (CollectionUtils.isNotEmpty((Collection)showTypeList)) {
                Map typeMap = (Map)typeList.get(0);
                typeMap.put("value", agileTransDataDTO.getTransId());
            }
        }
        snapShotDTO.getContext().getBizParams().setShowDefine(showDefine);
        String transTips = MapUtils.getString((Map)bizParams, (Object)"transTips");
        if (StringUtils.isNotEmpty((CharSequence)transTips)) {
            snapDataDTO.setTransTips(transTips);
        }
        this.getSnapShotDetail(snapDataInfoDTO, snapShotDTO);
        return snapDataInfoDTO;
    }

    public List<String> getTransList(AgileTransDataDTO agileTransDataDTO, AuthoredUser authoredUser, String lang) {
        String dmcId = this.getDmcId(agileTransDataDTO.getSnapshotId(), authoredUser.getTenantId(), authoredUser.getUserId());
        if (StringUtils.isEmpty((CharSequence)dmcId)) {
            return Lists.newArrayList();
        }
        SnapShotDTO snapShotDTO = this.dmcService.getAgileData(dmcId);
        if (snapShotDTO == null) {
            return Lists.newArrayList();
        }
        return this.adeService.getTransList(snapShotDTO, authoredUser, lang);
    }

    public Map<String, Object> getSolutionStepBySnapshotId(String snapshotId, String tenantId, String userId) {
        if (snapshotId == null || tenantId == null || userId == null) {
            throw new IllegalArgumentException("snapshotId, tenantId, and userId cannot be null");
        }
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, tenantId, userId);
        if (snapshotInfo == null) {
            throw new RuntimeException("Snapshot not found for id: " + snapshotId);
        }
        ContextDTO context = snapshotInfo.getContext();
        if (context == null) {
            throw new RuntimeException("Context not found in snapshot: " + snapshotId);
        }
        BizParamsDTO bizParams = context.getBizParams();
        if (bizParams == null) {
            throw new RuntimeException("BizParams not found in context");
        }
        String method = bizParams.getMethod();
        if (method == null) {
            throw new RuntimeException("Method is null");
        }
        Map datasetMap = Maps.newHashMap();
        if (StringUtils.equals((CharSequence)"dataset", (CharSequence)method)) {
            List datasetList = bizParams.getDatasetList();
            if (datasetList == null || datasetList.isEmpty()) {
                throw new RuntimeException("DatasetList is empty or null");
            }
            Map firstDataset = (Map)datasetList.get(0);
            if (firstDataset == null || firstDataset.get("datasetId") == null) {
                throw new RuntimeException("DatasetId not found in first dataset");
            }
            datasetMap = bizParams.getDataset();
            if (datasetMap == null) {
                throw new RuntimeException("Dataset map is null");
            }
        }
        if (StringUtils.equals((CharSequence)"metric", (CharSequence)method) && (datasetMap = bizParams.getMetric()) == null) {
            throw new RuntimeException("Dataset map is null");
        }
        return datasetMap;
    }
}

