/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.app.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class MongoTemplateConfig {
    @Value(value="${spring.data.mongodb-api-log.uri}")
    private String uriLog;
    @Value(value="${spring.data.mongodb-api-log.database}")
    private String databaseLog;
    @Value(value="${spring.data.mongodb-agileData-log.uri}")
    private String uriAgileDataLog;
    @Value(value="${spring.data.mongodb-agileData-log.database}")
    private String databaseAgileDataLog;
    @Value(value="${spring.data.mongodb-agileData-log.agileDataPagebase}")
    private String databaseagileDataPage;

    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.databaseLog);
    }

    @Bean(value={"mongoAgileDataLogTemplate"})
    public MongoTemplate mongoAgileDataTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriAgileDataLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.databaseAgileDataLog);
        MongoConverter converter = mongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return mongoTemplate;
    }

    @Bean(value={"mongoAgileDataPageViewTemplate"})
    public MongoTemplate mongoAgileDataPageViewTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriAgileDataLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.databaseagileDataPage);
        MongoConverter converter = mongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return mongoTemplate;
    }
}

