/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.ade.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.SDScencDTO;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeDataSetFieldReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeSpecialReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeTargetReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileAdeApcReqDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class ADEServiceImpl
implements ADEService {
    private static final Logger log = LoggerFactory.getLogger(ADEServiceImpl.class);
    @Autowired
    private AdtEnvProperties adtEnvProperties;
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Autowired
    private EchoService echoService;

    public SnapShotDTO getSnapShotData(SDScencDTO sdScencDTO) {
        String url = this.adtEnvProperties.getAdeUri() + "/api/test/nacos/info";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)sdScencDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, SnapShotDTO.class, new Object[0]);
            return (SnapShotDTO)respEntity.getBody();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_GET_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)sdScencDTO), e.getMessage()});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.ADE_GET_SNAPDATA_FAIL.getErrCode(), (Exception)e);
        }
    }

    public Map<String, Object> getRealtimeSnapShotData(AuthoredUser user, ADEScencDTO adeScencDTO, AthenaMessageEvent event) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("\u83b7\u53d6ade\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)adeScencDTO));
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", user.getToken());
        headers.set("locale", event.getLang());
        headers.set("Routerkey", user.getTenantId());
        headers.set("messageId", event.getPtxId());
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity((Object)adeScencDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            if ("-1".equals(((Map)((BaseResultDTO)response.getBody()).getResponse()).get("code"))) {
                this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42ADE\u5f02\u5e38", (String)JsonUtils.objectToString((Object)adeScencDTO), (String)JsonUtils.objectToString((Object)response), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            }
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)"1", (String)JsonUtils.objectToString((Object)adeScencDTO), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0122.getErrCode(), (String)JsonUtils.objectToString((Object)adeScencDTO), (String)TroubleToolCodeEnum.ADT_901_0122.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)", "ADE\u8d85\u65f6", JsonUtils.objectToString((Object)adeScencDTO), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"ADE\u8d85\u65f6", (String)JsonUtils.objectToString((Object)adeScencDTO), (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406", (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0121.getErrCode(), (String)JsonUtils.objectToString((Object)adeScencDTO), (String)TroubleToolCodeEnum.ADT_901_0121.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)adeScencDTO), e.getMessage()});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42ADE\u5f02\u5e38", (String)JsonUtils.objectToString((Object)adeScencDTO), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public Map<String, Object> getSchemaSQL(AuthoredUser user, String question2, String local) {
        LogDto logDto = new LogDto("\u83b7\u53d6\u67e5\u8be2sql\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)question2));
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/get/querySchema";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", user.getToken());
        headers.set("locale", local);
        HashMap params = Maps.newHashMap();
        params.put("tenantId", user.getTenantId());
        params.put("locale", local);
        params.put("question", question2);
        params.put("userToken", user.getToken());
        params.put("useDcp", false);
        params.put("useSQL", true);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6\u67e5\u8be2sql\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SQL_FAIL.getErrCode(), JsonUtils.objectToString((Object)params), e.getMessage()});
            return null;
        }
    }

    public Map<String, Object> getSchemaSQLNoGPT(AgileDataLogEvent event) {
        LogDto logDto = new LogDto("\u83b7\u53d6\u67e5\u8be2sql\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)event.getQuestion()));
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/get/querySchemaNoGPT";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", event.getAuthoredUser().getToken());
        headers.set("locale", event.getLocal());
        headers.set("Routerkey", event.getAuthoredUser().getUserId());
        headers.set("messageId", String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity((Object)event.getAdeScencDTO(), (MultiValueMap)headers);
        log.info("adt getSchemaSQLNoGPT \u5165\u53c2 :{}", (Object)JsonUtils.objectToString((Object)httpEntity));
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6\u67e5\u8be2sql\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SQL_FAIL.getErrCode(), JsonUtils.objectToString((Object)event.getAdeScencDTO()), e.getMessage()});
            return null;
        }
    }

    public Map<String, Object> reqTargetSnapShotData(AdeTargetReqDTO newAdeSceneReqDTO, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("\u83b7\u53d6ade\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)newAdeSceneReqDTO));
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/new/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", event.getUser().getToken());
        headers.set("locale", event.getLang());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("messageId", String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity((Object)newAdeSceneReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}: , \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)httpEntity), e.getMessage()});
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public Map<String, Object> reqMetricSnapShotData(Map<String, Object> param, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("\u83b7\u53d6ade\u5165\u53c2\uff1a" + JsonUtils.objectToString(param));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", event.getUser().getToken());
        headers.set("locale", event.getLang());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("messageId", event.getPtxId());
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)"1", (String)JsonUtils.objectToString(param), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0122.getErrCode(), (String)JsonUtils.objectToString(param), (String)TroubleToolCodeEnum.ADT_901_0122.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)", "ADE\u8d85\u65f6", JsonUtils.objectToString(param), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"ADE\u8d85\u65f6", (String)JsonUtils.objectToString(param), (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406", (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0121.getErrCode(), (String)JsonUtils.objectToString(param), (String)TroubleToolCodeEnum.ADT_901_0121.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString(param), e.getMessage()});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42ADE\u5f02\u5e38", (String)JsonUtils.objectToString(param), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public Map<String, Object> reqSpecialSnapShotData(AdeSpecialReqDTO adeSpecialReqDTO, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("\u83b7\u53d6ade\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)adeSpecialReqDTO));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/hasAnswer/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", event.getUser().getToken());
        headers.set("locale", event.getLang());
        headers.set("Routerkey", event.getUser().getTenantId());
        HttpEntity httpEntity = new HttpEntity((Object)adeSpecialReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)"1", (String)JsonUtils.objectToString((Object)adeSpecialReqDTO), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0122.getErrCode(), (String)JsonUtils.objectToString((Object)adeSpecialReqDTO), (String)TroubleToolCodeEnum.ADT_901_0122.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->ADE (reqMetricSnapShotData)", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", event.getQuestion(), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttp://xxxx.com\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)TroubleToolCodeEnum.ADT_901_0121.getErrCode(), (String)JsonUtils.objectToString((Object)adeSpecialReqDTO), (String)TroubleToolCodeEnum.ADT_901_0121.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("\u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)httpEntity), e});
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public SnapShotDTO reqApcSnapShotDataBySync(AgileAdeApcReqDTO req, AuthoredUser user, String local) {
        LogDto logDto = new LogDto("\u83b7\u53d6ade apc \u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)req));
        long getQuerySchemaTook = System.currentTimeMillis();
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put((String)"traceId", (String)ptxId);
        MDC.put((String)"PtxId", (String)ptxId);
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/screen/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", user.getToken());
        headers.set("Routerkey", user.getTenantId());
        headers.set("locale", local);
        headers.set("messageId", ptxId);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + ((BaseResultDTO)response.getBody()).getResponse());
            log.info(logReturnDto.toString());
            Map resultMap = (Map)((BaseResultDTO)response.getBody()).getResponse();
            Map dataMap = MapUtils.getMap((Map)resultMap, (Object)"data");
            return (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataMap), SnapShotDTO.class);
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->ADE (reqMetricSnapShotData)", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", JsonUtils.objectToString((Object)req), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttp://xxxx.com\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)httpEntity), e});
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public Map<String, Object> getEssentialFactor(AthenaMessageEvent event, Map<String, Object> param) {
        LogDto logDto = new LogDto("\u83b7\u53d6ade\u5165\u53c2\uff1a" + JsonUtils.objectToString(param));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/getEssentialFactor";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", event.getUser().getToken());
        headers.set("locale", event.getLang());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("messageId", event.getPtxId());
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6ade\u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog((String)"adt", (String)"getEssentialFactor", (String)"1", (String)JsonUtils.objectToString(param), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getEssentialFactor", (String)TroubleToolCodeEnum.ADT_901_0122.getErrCode(), (String)JsonUtils.objectToString(param), (String)TroubleToolCodeEnum.ADT_901_0122.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)", "ADE\u8d85\u65f6", JsonUtils.objectToString(param), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"ADE\u8d85\u65f6", (String)JsonUtils.objectToString(param), (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406", (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getEssentialFactor", (String)TroubleToolCodeEnum.ADT_901_0121.getErrCode(), (String)JsonUtils.objectToString(param), (String)TroubleToolCodeEnum.ADT_901_0121.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), JsonUtils.objectToString(param), e.getMessage()});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42ADE\u5f02\u5e38", (String)JsonUtils.objectToString(param), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    public Map<String, Object> getDataSetFieldList(AuthoredUser user, AdeDataSetFieldReqDTO req, String userLang) {
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put((String)"traceId", (String)ptxId);
        MDC.put((String)"PtxId", (String)ptxId);
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/get/dataSetFieldList";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", user.getToken());
        headers.set("userId", user.getUserId());
        headers.set("Routerkey", user.getTenantId());
        headers.set("locale", userLang);
        headers.set("messageId", ptxId);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)req));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public Map<String, Object> transPresentAgileData(AuthoredUser user, String transId, String originalId, SnapShotDTO snapShotDTO, String lang) {
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/chartConvert";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("userId", user.getUserId());
        headers.set("Routerkey", user.getTenantId());
        headers.set("locale", lang);
        HashMap req = Maps.newHashMap();
        if (snapShotDTO != null) {
            req.put("snapshot", snapShotDTO);
        }
        req.put("chartType", transId);
        if (StringUtils.isNotEmpty((CharSequence)originalId)) {
            req.put("originalSnapshotDataFileId", originalId);
        }
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6ADE\u56fe\u8868\u8f6c\u6362\u7ed3\u679c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)req));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6ADE\u56fe\u8868\u8f6c\u6362\u7ed3\u679c\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public List<String> getTransList(SnapShotDTO snapShotDTO, AuthoredUser user, String lang) {
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put((String)"traceId", (String)ptxId);
        MDC.put((String)"PtxId", (String)ptxId);
        String url = this.adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/snapshotConvertChart";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("userId", user.getUserId());
        headers.set("Routerkey", user.getTenantId());
        headers.set("locale", lang);
        headers.set("messageId", ptxId);
        HashMap req = Maps.newHashMap();
        req.put("snapshot", snapShotDTO);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6ADE\u56fe\u8868\u8f6c\u6362\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)req));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6ADE\u56fe\u8868\u8f6c\u6362\u5217\u8868\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            Map result = (Map)((BaseResultDTO)response.getBody()).getResponse();
            if (MapUtils.isEmpty((Map)result)) {
                return null;
            }
            List transList = (List)result.get("data");
            return transList;
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }
}

