/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dto.ade;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class AdeTargetReqDTO
implements Serializable {
    private String tenantId;
    private String requestor;
    private String requestPersonName;
    private String actionId;
    private String requestTime;
    private String locale;
    private SceneDTO scene;
    private Map<String, Object> recastDefine;
    private Map<String, Object> param;
    private Map<String, Object> showDefine;
    private String requestType;

    public static AdeTargetReqDTO buildAdeReq(Map<String, Object> data, AthenaMessageEvent event) {
        AdeTargetReqDTO adeTargetReqDTO = new AdeTargetReqDTO();
        String actionId = String.valueOf(SnowflakeIdWorker.getInstance().newId());
        Map msgExt = event.getMsgExt();
        if (!Objects.isNull(msgExt) && !Objects.isNull(msgExt.get("type")) && "agileSubscribe".equals(String.valueOf(msgExt.get("type")))) {
            HashMap param = MapUtil.newHashMap();
            param.put("type", "2");
            param.put("asaCode", event.getAsaCode());
            adeTargetReqDTO.setParam((Map)param);
        }
        adeTargetReqDTO.setTenantId(event.getUser().getTenantId());
        adeTargetReqDTO.setRequestor(event.getUser().getUserId());
        adeTargetReqDTO.setRequestPersonName(event.getUser().getUserName());
        adeTargetReqDTO.setLocale(LocaleContextHolder.getLocale().toString());
        adeTargetReqDTO.setRequestTime(TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        adeTargetReqDTO.setScene(event.getSceneDTO());
        adeTargetReqDTO.setActionId(actionId);
        HashMap recast = MapUtil.newHashMap();
        List show = (List)data.get("show");
        List showType = (List)data.get("showType");
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        dataList.add(data);
        recast.put(actionId, dataList);
        adeTargetReqDTO.setRecastDefine((Map)recast);
        HashMap showDefine = MapUtil.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)showType)) {
            showType.forEach(dto -> {
                if (!Objects.isNull(dto.get("actionId"))) {
                    dto.put("actionId", actionId);
                }
            });
        }
        showDefine.put("show", show);
        showDefine.put("showType", showType);
        adeTargetReqDTO.setRequestType("target");
        adeTargetReqDTO.setShowDefine((Map)showDefine);
        return adeTargetReqDTO;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getRequestor() {
        return this.requestor;
    }

    public String getRequestPersonName() {
        return this.requestPersonName;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getRequestTime() {
        return this.requestTime;
    }

    public String getLocale() {
        return this.locale;
    }

    public SceneDTO getScene() {
        return this.scene;
    }

    public Map<String, Object> getRecastDefine() {
        return this.recastDefine;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public Map<String, Object> getShowDefine() {
        return this.showDefine;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setRequestor(String requestor) {
        this.requestor = requestor;
    }

    public void setRequestPersonName(String requestPersonName) {
        this.requestPersonName = requestPersonName;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public void setRequestTime(String requestTime) {
        this.requestTime = requestTime;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setScene(SceneDTO scene) {
        this.scene = scene;
    }

    public void setRecastDefine(Map<String, Object> recastDefine) {
        this.recastDefine = recastDefine;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public void setShowDefine(Map<String, Object> showDefine) {
        this.showDefine = showDefine;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdeTargetReqDTO)) {
            return false;
        }
        AdeTargetReqDTO other = (AdeTargetReqDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$requestor = this.getRequestor();
        String other$requestor = other.getRequestor();
        if (this$requestor == null ? other$requestor != null : !this$requestor.equals(other$requestor)) {
            return false;
        }
        String this$requestPersonName = this.getRequestPersonName();
        String other$requestPersonName = other.getRequestPersonName();
        if (this$requestPersonName == null ? other$requestPersonName != null : !this$requestPersonName.equals(other$requestPersonName)) {
            return false;
        }
        String this$actionId = this.getActionId();
        String other$actionId = other.getActionId();
        if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
            return false;
        }
        String this$requestTime = this.getRequestTime();
        String other$requestTime = other.getRequestTime();
        if (this$requestTime == null ? other$requestTime != null : !this$requestTime.equals(other$requestTime)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        SceneDTO this$scene = this.getScene();
        SceneDTO other$scene = other.getScene();
        if (this$scene == null ? other$scene != null : !this$scene.equals(other$scene)) {
            return false;
        }
        Map this$recastDefine = this.getRecastDefine();
        Map other$recastDefine = other.getRecastDefine();
        if (this$recastDefine == null ? other$recastDefine != null : !((Object)this$recastDefine).equals(other$recastDefine)) {
            return false;
        }
        Map this$param = this.getParam();
        Map other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        Map this$showDefine = this.getShowDefine();
        Map other$showDefine = other.getShowDefine();
        if (this$showDefine == null ? other$showDefine != null : !((Object)this$showDefine).equals(other$showDefine)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        return !(this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdeTargetReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $requestor = this.getRequestor();
        result = result * 59 + ($requestor == null ? 43 : $requestor.hashCode());
        String $requestPersonName = this.getRequestPersonName();
        result = result * 59 + ($requestPersonName == null ? 43 : $requestPersonName.hashCode());
        String $actionId = this.getActionId();
        result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
        String $requestTime = this.getRequestTime();
        result = result * 59 + ($requestTime == null ? 43 : $requestTime.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        SceneDTO $scene = this.getScene();
        result = result * 59 + ($scene == null ? 43 : $scene.hashCode());
        Map $recastDefine = this.getRecastDefine();
        result = result * 59 + ($recastDefine == null ? 43 : ((Object)$recastDefine).hashCode());
        Map $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        Map $showDefine = this.getShowDefine();
        result = result * 59 + ($showDefine == null ? 43 : ((Object)$showDefine).hashCode());
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        return result;
    }

    public String toString() {
        return "AdeTargetReqDTO(tenantId=" + this.getTenantId() + ", requestor=" + this.getRequestor() + ", requestPersonName=" + this.getRequestPersonName() + ", actionId=" + this.getActionId() + ", requestTime=" + this.getRequestTime() + ", locale=" + this.getLocale() + ", scene=" + this.getScene() + ", recastDefine=" + this.getRecastDefine() + ", param=" + this.getParam() + ", showDefine=" + this.getShowDefine() + ", requestType=" + this.getRequestType() + ")";
    }
}

