/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.iam.Impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.dto.iam.AthenaUserDto;
import com.digiwin.athena.adt.domain.iam.AdtIAMAService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IAMServiceImpl
implements AdtIAMAService {
    private static final Logger log = LoggerFactory.getLogger(IAMServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${athena.auth.appToken}")
    private String appToken;
    @Value(value="${iam.uri:}")
    private String iamUrl;

    public AthenaUserDto getUserInfoByUserId(String token, String userId, boolean queryLanguage) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        String url = this.iamUrl + "/api/iam/v2/user/full";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        log.info("\u8c03\u7528iam\u63a5\u53e3\u7528\u7528\u6237id\u67e5\u8be2\u7528\u6237\u4fe1\u606f,url:{},entity:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8c03\u7528iam\u63a5\u53e3\u7528\u7528\u6237id\u67e5\u8be2\u7528\u6237\u4fe1\u606f,url:{},result:{}", (Object)url, (Object)JsonUtils.objectToString((Object)respEntity));
            return (AthenaUserDto)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.IAM_USER_INFO_FAIL.getErrCode(), e.getMessage(), e.getMessage()});
            throw ErrorCodeEnum.IAM_USER_INFO_FAIL.getBusinessException();
        }
    }

    public String getRealTimeTenantToken(String tenantId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        String url = this.iamUrl + "/api/iam/v2/identity/login/internal";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        httpHeaders.add("Client-Agent", "mobileplatform-2.0.1.1");
        httpHeaders.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(param), (MultiValueMap)httpHeaders);
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token#pre,url:{},httpEntity:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token#post,url:{},response:{}", (Object)url, (Object)JsonUtils.objectToString((Object)response));
        String tenantToken = String.valueOf(((Map)response.getBody()).get("token"));
        if (StringUtils.isEmpty((CharSequence)tenantToken)) {
            log.error("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token\u5f02\u5e38");
            throw new IllegalArgumentException(String.format("\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7\u79df\u6237token:%s\u63a5\u53e3\u5f02\u5e38", "getTenantToken"));
        }
        return tenantToken;
    }
}

