/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.knowledge.Impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.km.KMApplicationApcResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectConfigReqDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDataSetResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMPurchaseModelResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMUserAppCodesResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class KmServiceImpl
implements KmService {
    private static final Logger log = LoggerFactory.getLogger(KmServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${athena.auth.appToken}")
    private String appToken;
    @Autowired
    private EchoService echoService;

    public KMScencDTO getKmSceneInfo(AthenaMessageEvent event, String code, String local, String token, String routerkey) {
        long getQuerySchemaTook = System.currentTimeMillis();
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneMaps";
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotEmpty((CharSequence)local)) {
            headers.set("locale", local);
        }
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.set("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerkey)) {
            headers.set("Routerkey", routerkey);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", code);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (KMScencDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u77e5\u8bc6\u56fe\u8c31\u7ec4\u4ef6(KM)", "KM\u8d85\u65f6", code, "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42KM\u5f02\u5e38", (String)code, (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406", (String)"1"), token, routerkey);
            throw ErrorCodeEnum.KM_GET_TIME_OUT_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_GET_TITLE_FAIL.getErrCode(), code, e.getMessage()});
            throw ErrorCodeEnum.KM_GET_TITLE_FAIL.getBusinessException();
        }
    }

    public KMScencDTO getKmSceneCode(Map<String, Object> params, String local, String token) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneByTemplateAndTarget";
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.set("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)local)) {
            headers.set("locale", local);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (KMScencDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6KM\u573a\u666f\u5931\u8d25", params, e.getMessage()});
            return null;
        }
    }

    public List<KMPurchaseModelResDTO> queryKmPurchaseList(Integer type, String token, String tenantId, String userId) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/userMetricApplication?type=" + type + "&userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        log.info("\u8ba1\u8d39\u4e1a\u52a1 \u67e5\u8be2\u5f53\u524d\u7528\u6237\u5e94\u7528\u6240\u6709\u4fe1\u606f \u5165\u53c2:{} ,\u79df\u6237\uff1a{} ,token:{}", new Object[]{JsonUtils.objectToString((Object)url), tenantId, token});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8ba1\u8d39\u4e1a\u52a1 \u67e5\u8be2\u5f53\u524d\u7528\u6237\u5e94\u7528\u6240\u6709\u4fe1\u606f \u8fd4\u53c2:{}", (Object)JsonUtils.objectToString((Object)response));
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((BaseResultDTO)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}:, \u8bf7\u6c42code\uff1a{}:, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrMsg(), ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrCode(), e.getMessage()});
            throw ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getBusinessException();
        }
        return Collections.emptyList();
    }

    public KMUserAppCodesResDTO queryKmUserAppCodes(String token, String tenantId, String userId) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/userAppAuth?userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        log.info("\u8ba1\u8d39\u4e1a\u52a1 \u67e5\u8be2\u5f53\u524d\u7528\u6237\u6d41\u91cf\u5305\u5e94\u7528\u4fe1\u606f \u5165\u53c2:{},user:{}", (Object)JsonUtils.objectToString((Object)httpEntity), (Object)userId);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8ba1\u8d39\u4e1a\u52a1 \u67e5\u8be2\u5f53\u524d\u7528\u6237\u6d41\u91cf\u5305\u5e94\u7528\u4fe1\u606f \u8fd4\u53c2:{}", (Object)JsonUtils.objectToString((Object)response));
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (KMUserAppCodesResDTO)((BaseResultDTO)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}:, \u8bf7\u6c42code\uff1a{}:, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrMsg(), ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrCode(), e.getMessage()});
            throw ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getBusinessException();
        }
        return new KMUserAppCodesResDTO();
    }

    public List<String> querySceneByTenantId(String token, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        log.info("querySceneByTenantId tenantId:{}", (Object)tenantId);
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneByTenantId";
        HttpHeaders headers = new HttpHeaders();
        headers.add("routerKey", tenantId);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", token);
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"querySceneByTenantId \u5931\u8d25", tenantId, e.getMessage()});
            return null;
        }
    }

    public List<KMApplicationApcResDTO> queryApplicationByCode(AuthoredUser user, String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/queryApplicationByCode";
        HttpHeaders headers = new HttpHeaders();
        headers.add("routerKey", user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        params.put("sceneCode", code);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"queryApplicationByCode \u5931\u8d25", code, e.getMessage()});
            return null;
        }
    }

    public KMDatasetCommandIntentionsResDTO dataSetCommandIntentions(AuthoredUser user, String appCode) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/command/dataSetCommandIntentions?appCode=" + appCode;
        HttpHeaders headers = new HttpHeaders();
        headers.add("routerKey", user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (KMDatasetCommandIntentionsResDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"dataSetCommandIntentions \u5931\u8d25", appCode, e.getMessage()});
            return null;
        }
    }

    public List<KMDataSetResDTO> queryDataSetsByAppCode(AuthoredUser user, String appCode, String userLang) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/queryDataSetsByApp";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", userLang);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appCode", appCode);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((BaseResultDTO)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"queryDataSetsByAppCode \u5931\u8d25", appCode, e.getMessage()});
        }
        return null;
    }

    public ThemeMapBoardDTO getThemeMapBoardQuestion(AuthoredUser user, String questionId) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataBoard/queryBoardStep";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        HashMap params = Maps.newHashMap();
        params.put("questionId", questionId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u770b\u677f\u95ee\u9898\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)response));
            return (ThemeMapBoardDTO)((BaseResultDTO)Objects.requireNonNull(response.getBody())).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public String getVersion(AuthoredUser user) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/tenantVersion?tenantId=" + user.getTenantId();
        HttpHeaders headers = new HttpHeaders();
        headers.add("routerKey", user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (String)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"getVersion \u5931\u8d25", user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public Map<String, Object> updateCollectByConfig(AuthoredUser user, KMCollectConfigReqDTO kmCollectConfigReqDTO) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataSubscription/updateSubscriptionByConfig" + user.getTenantId();
        HttpHeaders headers = new HttpHeaders();
        headers.add("routerKey", user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"updateCollectByConfig \u5931\u8d25", user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public KMCollectStepResDTO getCollectStep(AuthoredUser user, String questionId) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataCollect/queryCollectStep";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        HashMap params = Maps.newHashMap();
        params.put("questionId", questionId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u770b\u677f\u95ee\u9898\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)response));
            return (KMCollectStepResDTO)((BaseResultDTO)Objects.requireNonNull(response.getBody())).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

