/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.report.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.constant.AgileDataSourceEnum;
import com.digiwin.athena.adt.agileReport.constant.AthenaMessageEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.dao.AgileDataConfigMapper;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneCommonDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneUserCommonDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbsAgileEventProcess {
    private static final Logger log = LoggerFactory.getLogger(AbsAgileEventProcess.class);
    @Autowired
    private UserService userService;
    @Resource
    private AgileDataConfigMapper agileDataConfigMapper;
    @Autowired
    private KmService kmService;
    private static final String DESIGNER = "designer";
    private static final String METRIC = "metric";
    private static final String SPECIAL = "special";
    private static final String SPECIAL_LITE = "special_lite";
    private static final String TENANT_ID = "tenant_id";

    public AthenaMessageEvent init(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user) {
        AthenaMessageEvent event = new AthenaMessageEvent();
        try {
            this.initUserInfo(request, athenaMessageDTO, event, user);
            this.initEventInfo(athenaMessageDTO, event);
            event.setMessageType(this.getMessageType(event, user));
            this.analyzeAsaCode(athenaMessageDTO, event);
            this.initEventMsgExt(event, athenaMessageDTO);
            this.initSchemaReq(event, athenaMessageDTO);
            this.setSourceDataByMessageType(event);
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"layeredQuestion", (String)TroubleToolCodeEnum.ADT_901_0101.getErrCode(), (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)TroubleToolCodeEnum.ADT_901_0101.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0101.getSuggestion());
        }
        LogUtils.buildAgileLog((String)"adt", (String)"layeredQuestion", (String)"1", (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)JsonUtils.objectToString((Object)event), (String)"");
        return event;
    }

    private void initSchemaReq(AthenaMessageEvent event, AthenaMessageDTO athenaMessageDTO) {
        QuerySchemaReqDTO querySchemaReqDTO = QuerySchemaReqDTO.builderSchemaReq((AthenaMessageEvent)event);
        querySchemaReqDTO.setMetricIdList(athenaMessageDTO.getIntentCode());
        querySchemaReqDTO.setCombinationMsg(athenaMessageDTO.getCombinationMsg());
        querySchemaReqDTO.setProductVersion(event.getProductVersion());
        querySchemaReqDTO.setDatasetIdList(event.getDatasetIdList());
        querySchemaReqDTO.setProbe(event.getProbe().booleanValue());
        querySchemaReqDTO.setMultiDialogue(event.getProbe());
        querySchemaReqDTO.setAppCode(athenaMessageDTO.getAppCode());
        querySchemaReqDTO.setMessageId4Ania(athenaMessageDTO.getMessageId());
        querySchemaReqDTO.setSectionId(athenaMessageDTO.getSectionId());
        querySchemaReqDTO.setConversationId(athenaMessageDTO.getConversationId());
        event.setQuerySchemaReqDTO(querySchemaReqDTO);
    }

    private void initEventMsgExt(AthenaMessageEvent event, AthenaMessageDTO athenaMessageDTO) {
        if (Objects.nonNull(event.getMsgExt())) {
            Object undeleteTable;
            String sessionId = Objects.nonNull(athenaMessageDTO.getMsgExt().get("sessionId")) ? athenaMessageDTO.getMsgExt().get("sessionId").toString() : null;
            event.setSessionId(sessionId);
            event.getMsgBody().put("sessionId", sessionId);
            event.getMsgExt().put("isAlarm", false);
            event.getMsgExt().put("messageId", event.getGenerateSerialNo());
            event.getMsgExt().put("sessionId", sessionId);
            if (event.getMsgExt() != null && event.getMsgExt().containsKey("sceneCode") && StringUtils.isNotEmpty((CharSequence)String.valueOf(event.getMsgExt().get("sceneCode")))) {
                event.setDebug(true);
            }
            event.setUndeletable(Objects.nonNull(undeleteTable = athenaMessageDTO.getMsgExt().get("undeletable")) && (Boolean)undeleteTable != false);
            String productVersion = this.getProductVersionByAppCode(athenaMessageDTO.getAppCode(), event);
            event.setProductVersion(productVersion);
            Object datasetIdList = athenaMessageDTO.getMsgExt().get("datasetIdList");
            event.setDatasetIdList(Objects.nonNull(datasetIdList) ? (List)datasetIdList : new ArrayList());
            Object probe = event.getMsgExt().get("probe");
            event.setProbe(Boolean.valueOf(Objects.nonNull(probe) ? (Boolean)probe : false));
            String conversationMode = Objects.nonNull(event.getMsgBody().get("conversationMode")) ? String.valueOf(event.getMsgBody().get("conversationMode")) : "";
            event.setConversationMode(conversationMode);
        }
    }

    public String getProductVersionByAppCode(String appCode, AthenaMessageEvent event) {
        KMDatasetCommandIntentionsResDTO cIData;
        if (!StringUtils.isEmpty((CharSequence)appCode) && Objects.nonNull(cIData = this.kmService.dataSetCommandIntentions(event.getUser(), appCode)) && Objects.nonNull(cIData.getAppType())) {
            Integer appType = cIData.getAppType();
            if (12 == appType) {
                return "V2";
            }
            return "V1";
        }
        return "V1";
    }

    private void initEventInfo(AthenaMessageDTO athenaMessageDTO, AthenaMessageEvent event) {
        event.setAnswerResult(Integer.valueOf(1));
        event.setSendNana(true);
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put((String)"traceId", (String)ptxId);
        MDC.put((String)"PtxId", (String)ptxId);
        log.info("traceId : {}", (Object)ptxId);
        log.info("mdc PtxId : {}", (Object)MDC.get((String)"PtxId"));
        event.setPtxId(ptxId);
        event.setMsgBody(athenaMessageDTO.getMsgBody());
        event.setMsgExt(athenaMessageDTO.getMsgExt());
        event.setAskTime(LocalDateTime.now());
        Long generateSerialNo = SnowflakeIdWorker.getInstance().newId();
        String question2 = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        event.setQuestion(question2);
        event.setGenerateSerialNo(generateSerialNo);
        log.info("agiledata_adt_" + generateSerialNo);
    }

    private void initUserInfo(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AthenaMessageEvent event, AuthoredUser user) {
        LogDto logDto;
        AuthoredUser adtUser = this.setMqUserInfoByAthena(athenaMessageDTO.getMsgExt(), user);
        String clientAgent = this.getClientAgent(request, athenaMessageDTO.getMsgExt());
        List terminalList = AbsAgileEventProcess.getTerminalList((String)clientAgent);
        SceneDTO sceneDTO = this.builderSceneDTO(user, terminalList);
        String userLangName = this.getUserLangByParam(athenaMessageDTO.getMsgExt());
        if (StringUtils.isEmpty((CharSequence)userLangName)) {
            userLangName = this.userService.getUserLangNameByUserId(adtUser.getUserId(), adtUser.getTenantId(), adtUser.getToken());
            logDto = new LogDto("\u672a\u4ece\u5a1c\u5a1c\u83b7\u53d6\u7528\u6237\u591a\u8bed\u8a00\u4fe1\u606f\uff0c\u4eceIAM\u83b7\u53d6\u7ed3\u679c\uff1a" + userLangName);
            logDto.toString();
        }
        logDto = new LogDto("\u83b7\u53d6\u7528\u6237\u591a\u8bed\u8a00\u4fe1\u606f:" + userLangName);
        logDto.toString();
        event.setSceneDTO(sceneDTO);
        event.setUser(adtUser);
        event.setLang(userLangName);
        event.setTerminal(clientAgent);
    }

    public void analyzeAsaCode(AthenaMessageDTO athenaMessageDTO, AthenaMessageEvent event) {
        if (Objects.isNull(athenaMessageDTO.getMsgExt())) {
            event.setAsaCode(athenaMessageDTO.getAsaCode());
            return;
        }
        String asaCode = Optional.ofNullable(athenaMessageDTO.getMsgExt().get("asaCode")).map(Object::toString).filter(StringUtils::isNotEmpty).orElseGet(() -> Optional.ofNullable(athenaMessageDTO.getMsgExt().get("assistantCode")).map(Object::toString).filter(StringUtils::isNotEmpty).orElse(athenaMessageDTO.getAsaCode()));
        event.setAsaCode(asaCode);
    }

    public void setSourceDataByMessageType(AthenaMessageEvent event) {
        String messageType = event.getMessageType();
        if (AthenaMessageEnum.DEBUG.getValue().equals(messageType) || AthenaMessageEnum.PARAM.getValue().equals(messageType) || AthenaMessageEnum.METRIC_DEBUG.getValue().equals(messageType)) {
            event.setSourceName(AgileDataSourceEnum.DEBUG_MODEL.getName());
            event.setSourceCode(AgileDataSourceEnum.DEBUG_MODEL.getCode());
        } else {
            event.setSourceName(AgileDataSourceEnum.QUERY.getName());
            event.setSourceCode(AgileDataSourceEnum.QUERY.getCode());
        }
    }

    public String getUserLangByParam(Map<String, Object> msgExt) {
        return Optional.ofNullable(msgExt).map(ext -> ext.get("language")).map(Object::toString).orElse("");
    }

    public List<SceneCommonDTO> buildWhat() {
        SceneCommonDTO whatSe = new SceneCommonDTO();
        whatSe.setType("realTimeQuery");
        return Collections.singletonList(whatSe);
    }

    public List<SceneCommonDTO> buildWhen() {
        SceneCommonDTO whenSe = new SceneCommonDTO();
        whenSe.setType("currentTime");
        whenSe.setValue(LocalDateTime.now().toString());
        return Collections.singletonList(whenSe);
    }

    public List<SceneUserCommonDTO> buildWho(AuthoredUser user) {
        ArrayList value = Lists.newArrayList();
        HashMap<String, Object> whoValue = new HashMap<String, Object>();
        whoValue.put("id", user.getUserId());
        whoValue.put("name", user.getUserName());
        whoValue.put("roles", user.getRoles());
        whoValue.put("sid", user.getSid());
        value.add(whoValue);
        SceneUserCommonDTO whoSe = new SceneUserCommonDTO();
        whoSe.setType("user");
        whoSe.setValue((List)value);
        return Collections.singletonList(whoSe);
    }

    public SceneDTO builderSceneDTO(AuthoredUser user, List<String> terminalList) {
        SceneDTO sceneDTO = new SceneDTO();
        sceneDTO.setWho(this.buildWho(user));
        sceneDTO.setWhat(this.buildWhat());
        sceneDTO.setWhen(this.buildWhen());
        sceneDTO.setTerminal(new ArrayList());
        return sceneDTO;
    }

    public String getClientAgent(HttpServletRequest request, Map<String, Object> msgExt) {
        if (request == null) {
            return "";
        }
        return Optional.ofNullable(msgExt).map(ext -> ext.get("client-agent")).map(Object::toString).orElseGet(() -> {
            String agentHeader = request.getHeader("client-agent");
            return (String)StringUtils.defaultIfEmpty((CharSequence)agentHeader, (CharSequence)request.getHeader("Client-Agent"));
        });
    }

    public static List<String> getTerminalList(String clientAgent) {
        return StringUtils.isEmpty((CharSequence)clientAgent) ? Collections.emptyList() : Collections.singletonList(clientAgent);
    }

    public AuthoredUser setMqUserInfoByAthena(Map<String, Object> msgExt, AuthoredUser user) {
        AuthoredUser authoredUser = new AuthoredUser();
        BeanUtils.copyProperties((Object)user, (Object)authoredUser);
        if (MapUtils.isNotEmpty(msgExt) && !Objects.isNull(msgExt.get("userId")) && !Objects.isNull(msgExt.get("userName"))) {
            authoredUser.setUserId(String.valueOf(msgExt.get("userId")));
            authoredUser.setUserName(String.valueOf(msgExt.get("userName")));
        }
        return authoredUser;
    }

    public String getMessageType(AthenaMessageEvent event, AuthoredUser user) {
        String messageType = "0";
        String question2 = event.getQuestion();
        if (StringUtils.isEmpty((CharSequence)question2)) {
            return messageType;
        }
        String tenantServiceName = this.getAgileDataByUserConfig(user);
        if (AthenaMessageEnum.METRIC.getCode().equals(tenantServiceName)) {
            return AthenaMessageEnum.METRIC.getValue();
        }
        if (AthenaMessageEnum.SPECIAL.getCode().equals(tenantServiceName)) {
            return AthenaMessageEnum.SPECIAL.getValue();
        }
        if (AthenaMessageEnum.SPECIAL_LITE.getCode().equals(tenantServiceName)) {
            return AthenaMessageEnum.SPECIAL_LITE.getValue();
        }
        if (AthenaMessageEnum.MOCK.getCode().equals(tenantServiceName)) {
            return AthenaMessageEnum.MOCK.getValue();
        }
        if (question2.contains("*debug*") || question2.contains("*pr-debug*") || question2.contains("*test*")) {
            return AthenaMessageEnum.DEBUG.getValue();
        }
        if (question2.contains("*param*") || question2.contains("*pr-param*")) {
            return AthenaMessageEnum.PARAM.getValue();
        }
        if (question2.contains("*metric*")) {
            return AthenaMessageEnum.METRIC_DEBUG.getValue();
        }
        return messageType;
    }

    public String getAgileDataByUserConfig(AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        AgileDataConfig agileDataConfig = (AgileDataConfig)this.agileDataConfigMapper.selectOne((Wrapper)queryWrapper);
        String serviceName = "designer";
        if (agileDataConfig != null && StringUtils.isNotEmpty((CharSequence)agileDataConfig.getType()) && ("metric".equals(agileDataConfig.getType()) || "designer".equals(agileDataConfig.getType()) || "special".equals(agileDataConfig.getType()) || "special_lite".equals(agileDataConfig.getType()))) {
            serviceName = agileDataConfig.getType();
        }
        log.info("user agile data serviceName : {}", (Object)serviceName);
        return serviceName;
    }

    public void setAthenaEventMessageType(AthenaMessageEvent event, String messageType) {
        event.setMessageType(messageType);
    }

    public boolean checkUserScene(AthenaMessageEvent event) {
        String sceneCode = MapUtils.getString((Map)event.getMsgExt(), (Object)"sceneCode");
        List metricIdListObj = CommonUtil.objConvertListString(event.getMsgExt().get("metricIdList"));
        if (StringUtils.isEmpty((CharSequence)sceneCode) && CollectionUtils.isEmpty((Collection)metricIdListObj)) {
            return true;
        }
        List codes = this.kmService.querySceneByTenantId(event.getUser().getToken(), event.getUser().getTenantId());
        if (codes == null || codes.isEmpty()) {
            return false;
        }
        ArrayList<String> queryCodes = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            queryCodes.add(sceneCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIdListObj)) {
            queryCodes.addAll(metricIdListObj);
        }
        return new HashSet(codes).containsAll(queryCodes);
    }
}

