/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.report.impl;

import com.digiwin.athena.adt.agileReport.constant.AgileDataSourceEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataDetailUrlDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataEngineFileDownModel;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.excel.ExcelSheet;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.app.config.executor.ExecutorConfig;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.AgileDataPanelResDTO;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataSummarizeMsg;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.domain.uibot.UIBOTService;
import com.digiwin.athena.adt.sse.api.SSEManagerService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.AsyncEventBus;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class AgileReportProcessServiceImpl
extends AbsAgileDataProcess
implements AgileReportDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportProcessServiceImpl.class);
    @Autowired
    private AsyncEventBus localEventBus;
    @Resource
    private UIBOTService uibotService;
    @Autowired
    private AgileDataMessageService agileDataMessageService;
    @Resource
    private SSEManagerService sseManagerService;
    @Autowired
    private ExecutorConfig executorConfig;
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    @Autowired
    private SnapShotDataService snapShotDataService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private FileParsingService fileParsingService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private KmService kmService;
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoTemplate;

    public String processSDData(String processData, String fileName, AuthoredUser user) {
        UploadParamDTO uploadParamDTO = new UploadParamDTO();
        uploadParamDTO.setFileJson(processData);
        uploadParamDTO.setFileName(fileName);
        UploadAttachmentResp uploadAttachmentResp = this.dmcService.uploadAgileData(uploadParamDTO, user);
        return uploadAttachmentResp.getId();
    }

    public Map<String, String> processMessage(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)"\u5a1c\u5a1c\u95ee\u53e5\u8bf7\u6c42", (String)"");
        HashMap<String, String> resultType = new HashMap<String, String>();
        if (athenaMessageDTO.getMsgType() == null || athenaMessageDTO.getMsgBody().isEmpty()) {
            resultType.put("resultType", "NOTSUPPORT");
        }
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        this.localEventBus.post((Object)event);
        resultType.put("resultType", "PROCESS");
        return resultType;
    }

    public SnapShotDTO getAgileReportInfo(String dmcId) {
        return this.dmcService.getAgileData(dmcId);
    }

    public void compensateAgileData(SnapShotDTO snapShotDTO) {
        if (CollectionUtils.isNotEmpty((Collection)snapShotDTO.getContext().getPullData())) {
            snapShotDTO.getContext().getPullData().stream().forEach(pullDataDTO -> {
                Map computeMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)pullDataDTO), Map.class);
                computeMap.put("method", snapShotDTO.getContext().getBizParams().getMethod());
                computeMap.put("showDefine", snapShotDTO.getContext().getBizParams().getShowDefine());
                Map dataMap = this.uibotService.compensateAgileData(computeMap);
                if (MapUtils.isNotEmpty((Map)dataMap)) {
                    pullDataDTO.setData(dataMap);
                }
            });
        }
    }

    public AgileDataPanelResDTO panelProcessMessage(HttpServletRequest request, AthenaMessageDTO req, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"\u6570\u636e\u9762\u677f\u6536\u85cf\u8bf7\u6c42", (String)"");
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        AgileDataPanelResDTO agileDataPanelResDTO = new AgileDataPanelResDTO();
        AthenaMessageEvent event = this.init(request, req, user);
        event.setSendNana(false);
        event.setSourceName(AgileDataSourceEnum.PANEL.getName());
        event.setSourceCode(AgileDataSourceEnum.PANEL.getCode());
        String questionId = MapUtils.getString((Map)req.getMsgExt(), (Object)"questionId");
        if (StringUtils.isEmpty((CharSequence)questionId)) {
            result = this.agileDataMessageService.processRes(event);
        } else {
            KMCollectStepResDTO stepResDTO = this.kmService.getCollectStep(user, questionId);
            if (Objects.isNull(stepResDTO) || MapUtils.isEmpty((Map)stepResDTO.getSolutionStep()) || Objects.isNull(stepResDTO.getSnapshotId())) {
                result = this.agileDataMessageService.processRes(event);
                this.setPanelDataResult(result, agileDataPanelResDTO);
                return agileDataPanelResDTO;
            }
            this.buildEventByStepQuestion(event, stepResDTO);
            if (Objects.nonNull(stepResDTO.getBoardId()) && MapUtils.isNotEmpty((Map)stepResDTO.getSolutionStep())) {
                SnapShotDTO snapShotDTO = this.agileDataMessageService.processResV1(event, stepResDTO);
                result.setAlarm(false);
                result.setDataTipMessage("");
                result.setSnapshotId(snapShotDTO.getSnapshotId());
                result.setPanelMap(snapShotDTO);
                result.setRequestTime(snapShotDTO.getContext().getBizParams().getRequestTime());
            } else {
                result = this.agileDataMessageService.processRes(event);
            }
        }
        this.setPanelDataResult(result, agileDataPanelResDTO);
        return agileDataPanelResDTO;
    }

    public void setPanelDataResult(AgileDataProcessResDTO result, AgileDataPanelResDTO agileDataPanelResDTO) {
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        if (Objects.nonNull(result) && Objects.nonNull(result.getRequestTime())) {
            String formatDate = result.getRequestTime().format(sdf);
            agileDataPanelResDTO.setRequestTime(formatDate);
            agileDataPanelResDTO.setSnapshotId(result.getSnapshotId());
            agileDataPanelResDTO.setMsg(result.getMsg());
            agileDataPanelResDTO.setTotalUsage(result.getTotalUsage());
            agileDataPanelResDTO.setRemainingUsage(result.getRemainingUsage());
            agileDataPanelResDTO.setAlarm(result.isAlarm());
            agileDataPanelResDTO.setDataTipMessage(result.getDataTipMessage());
        }
    }

    public Map<String, Object> panelFlagShipProcessMessage(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user) {
        Map extData = aniaAssistantChatReqDTO.getMessage().getExtData();
        String questionId = MapUtils.getString((Map)extData, (Object)"questionId");
        HashMap<String, Map> athenaMessage = new HashMap<String, Map>();
        athenaMessage.put("msgExt", aniaAssistantChatReqDTO.getMessage().getExtData());
        HashMap msgBody = new HashMap();
        msgBody.put("text", aniaAssistantChatReqDTO.getMessage().getExtData().get("msg"));
        athenaMessage.put("msgBody", msgBody);
        AthenaMessageDTO athenaMessageDTO = (AthenaMessageDTO)CommonUtil.mapToObject(athenaMessage, AthenaMessageDTO.class);
        athenaMessageDTO.setMessageId(aniaAssistantChatReqDTO.getMessage().getMessageId());
        athenaMessageDTO.setSectionId(aniaAssistantChatReqDTO.getMessage().getSectionId());
        athenaMessageDTO.setConversationId(aniaAssistantChatReqDTO.getConversationId());
        athenaMessageDTO.setAppCode(aniaAssistantChatReqDTO.getAssistantId());
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        if (StringUtils.isNotEmpty((CharSequence)questionId)) {
            ThemeMapBoardDTO themeMapBoardDTO = this.kmService.getThemeMapBoardQuestion(user, questionId);
            if (Objects.isNull(themeMapBoardDTO) || Objects.isNull(themeMapBoardDTO.getSolutionStep())) {
                AgileDataProcessResDTO res = this.agileDataMessageService.processRes(event);
                return CommonUtil.convertObjectToMap((Object)res.getPanelMap());
            }
            return this.agileDataMessageService.processResV2(event, themeMapBoardDTO);
        }
        AgileDataProcessResDTO res = this.agileDataMessageService.processRes(event);
        return CommonUtil.convertObjectToMap((Object)res.getPanelMap());
    }

    private void buildEventByStepQuestion(AthenaMessageEvent event, KMCollectStepResDTO stepResDTO) {
        event.setDatasetIdList(stepResDTO.getDatasetList());
        event.getMsgExt().put("sceneCode", stepResDTO.getSceneCode());
        event.getMsgExt().put("metricIdList", stepResDTO.getMetricIdList());
    }

    public SseEmitter sseProcessMessage(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)"\u5a1c\u5a1c\u6d41\u5f0fV1\u95ee\u53e5\u8bf7\u6c42", (String)"");
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            this.agileDataMessageService.sseProcess(event, sseBaseEvent);
        }, this.executorConfig.asyncServiceExecutor());
        return sseEmitter;
    }

    public SseEmitter sseProcessMessageV2(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)aniaAssistantChatReqDTO), (String)"\u5a1c\u5a1c\u6d41\u5f0fV2\u95ee\u53e5\u8bf7\u6c42", (String)"");
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        HashMap<String, Map> athenaMessage = new HashMap<String, Map>();
        athenaMessage.put("msgExt", aniaAssistantChatReqDTO.getMessage().getExtData());
        HashMap msgBody = new HashMap();
        msgBody.put("text", aniaAssistantChatReqDTO.getMessage().getExtData().get("msg"));
        athenaMessage.put("msgBody", msgBody);
        AthenaMessageDTO athenaMessageDTO = (AthenaMessageDTO)CommonUtil.mapToObject(athenaMessage, AthenaMessageDTO.class);
        athenaMessageDTO.setMessageId(aniaAssistantChatReqDTO.getMessage().getMessageId());
        athenaMessageDTO.setSectionId(aniaAssistantChatReqDTO.getMessage().getSectionId());
        athenaMessageDTO.setConversationId(aniaAssistantChatReqDTO.getConversationId());
        athenaMessageDTO.setAppCode(aniaAssistantChatReqDTO.getAssistantId());
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        event.setAppCode(aniaAssistantChatReqDTO.getAssistantId());
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            this.agileDataMessageService.sseProcess(event, sseBaseEvent);
        }, this.executorConfig.asyncServiceExecutor());
        return sseEmitter;
    }

    public AgileDataDetailUrlDTO getDataDetailUrl(AuthoredUser user, String snapshotId, String locale) {
        AgileDataDetailUrlDTO agileDataDetailUrlDTO = new AgileDataDetailUrlDTO();
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        if (Objects.isNull(snapshotInfo)) {
            this.buildErrorMessage(agileDataDetailUrlDTO, locale);
            return agileDataDetailUrlDTO;
        }
        Map params = this.buildParams(snapshotInfo);
        if (Objects.isNull(params)) {
            return agileDataDetailUrlDTO;
        }
        AgileDataEngineFileDownModel adeFileDown = this.getFileDownUrl(user, params, locale);
        if (adeFileDown == null) {
            this.buildErrorMessage(agileDataDetailUrlDTO, locale);
            return agileDataDetailUrlDTO;
        }
        agileDataDetailUrlDTO.setDataUrl(adeFileDown.getData());
        agileDataDetailUrlDTO.setResult(Boolean.valueOf(StringUtils.equals((CharSequence)"200", (CharSequence)adeFileDown.getCode())));
        agileDataDetailUrlDTO.setErrorMessage(adeFileDown.getMsg());
        return agileDataDetailUrlDTO;
    }

    public AgileDataEngineFileDownModel getFileDownUrl(AuthoredUser user, Map<String, Object> params, String locale) {
        AgileDataEngineFileDownModel model = new AgileDataEngineFileDownModel();
        ArrayList header = (ArrayList)params.get("descriptionsList");
        ArrayList dataKey = (ArrayList)params.get("dataNamesList");
        List data = (List)params.get("data");
        HashMap<String, Object> excelRequest = new HashMap<String, Object>(2);
        StringBuilder sb = new StringBuilder();
        ArrayList<ExcelSheet> excelSheets = new ArrayList<ExcelSheet>(1);
        excelSheets.add(ExcelSheet.build((String)"\u56fe\u8868\u6570\u636e", (ArrayList)header, (ArrayList)dataKey, (List)data));
        excelRequest.put("fileName", "\u6570\u636e\u4e0b\u8f7d");
        excelRequest.put("fileData", excelSheets);
        excelRequest.put("tenantId", user.getTenantId());
        AgileDataEngineFileDownModel res = this.fileParsingService.getDmcShareUrl(user.getTenantId(), user.getToken(), locale, excelRequest);
        if (Objects.nonNull(res)) {
            return res;
        }
        return model;
    }

    private void buildErrorMessage(AgileDataDetailUrlDTO agileDataDetailUrlDTO, String locale) {
        agileDataDetailUrlDTO.setResult(Boolean.valueOf(false));
        agileDataDetailUrlDTO.setErrorMessage(this.messageUtil.getMessageByLangName("message.ade.dataUrl.error.msg", locale));
    }

    private Map<String, Object> buildParams(SnapShotDTO snapshotInfo) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        ContextDTO context = snapshotInfo.getContext();
        if (Objects.isNull(context)) {
            return null;
        }
        List pullData = context.getPullData();
        if (CollectionUtils.isEmpty((Collection)pullData)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)pullData)) {
            PullDataDTO pullDataDTO = (PullDataDTO)pullData.get(0);
            res.put("data", pullDataDTO.getData().get("data"));
            Map response = Optional.ofNullable((Map)pullDataDTO.getMetadata().get("response")).orElse(Collections.emptyMap());
            Map data = Optional.ofNullable((Map)response.get("data")).orElse(Collections.emptyMap());
            List fields = (List)data.get("field");
            ArrayList<String> descriptionsList = new ArrayList<String>();
            ArrayList<String> dataNamesList = new ArrayList<String>();
            for (Map field : fields) {
                descriptionsList.add(String.valueOf(field.get("description")));
                dataNamesList.add(String.valueOf(field.get("data_name")));
            }
            res.put("descriptionsList", descriptionsList);
            res.put("dataNamesList", dataNamesList);
        }
        return res;
    }

    public AgileDataSummarizeResDTO getAgileDataSummarize(AgileDataSummarizeReqDTO agileDataSummarizeReqDTO, AuthoredUser user) {
        AgileDataSummarizeResDTO agileDataSummarizeResDTO = new AgileDataSummarizeResDTO();
        String mongoSummarizeData = this.getMongoSummarizeMsg(agileDataSummarizeReqDTO.getSnapshotId());
        if (StringUtils.isNotEmpty((CharSequence)mongoSummarizeData)) {
            agileDataSummarizeResDTO.setSummarizeData(mongoSummarizeData);
            agileDataSummarizeResDTO.setData(true);
            return agileDataSummarizeResDTO;
        }
        String snapshotId = agileDataSummarizeReqDTO.getSnapshotId();
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        boolean queryDataFlag = snapshotInfo.getContext().getBizParams().isQueryDataFlag();
        if (!queryDataFlag) {
            agileDataSummarizeResDTO.setData(false);
            agileDataSummarizeResDTO.setSummarizeMsg("");
            return agileDataSummarizeResDTO;
        }
        String summarizeData = ((PullDataDTO)snapshotInfo.getContext().getPullData().get(0)).getSummarizeData();
        String question2 = snapshotInfo.getContext().getBizParams().getQuestion();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("question", question2);
        requestParam.put("resultData", summarizeData);
        requestParam.put("snapshotId", snapshotId);
        requestParam.put("userPromptList", new ArrayList());
        Map analysis = this.chatbiService.getResultAnalysis(requestParam, user);
        if (Objects.isNull(analysis) || Objects.isNull(analysis.get("data"))) {
            agileDataSummarizeResDTO.setSummarizeMsg("\u83b7\u53d6\u6570\u636e\u603b\u7ed3\u5f02\u5e38");
            agileDataSummarizeResDTO.setData(false);
            return agileDataSummarizeResDTO;
        }
        String summarizeMsg = String.valueOf(analysis.get("data"));
        agileDataSummarizeResDTO.setSummarizeData(summarizeMsg);
        agileDataSummarizeResDTO.setData(true);
        this.saveAgileDataSummarizeById(snapshotId, summarizeMsg);
        return agileDataSummarizeResDTO;
    }

    public void saveAgileDataSummarizeById(String snapshotId, String summarizeMsg) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId));
        List results = this.mongoTemplate.find(query, AgileDataSummarizeMsg.class);
        if (CollectionUtils.isEmpty((Collection)results)) {
            AgileDataSummarizeMsg msg = new AgileDataSummarizeMsg();
            msg.setSummarizeMsg(summarizeMsg);
            msg.setSnapshotId(snapshotId);
            this.mongoTemplate.insert((Object)msg);
        }
    }

    public String getMongoSummarizeMsg(String snapshotId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId));
        List results = this.mongoTemplate.find(query, AgileDataSummarizeMsg.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            return ((AgileDataSummarizeMsg)results.get(0)).getSummarizeMsg();
        }
        return null;
    }

    public Map<String, Object> getAppVersion(AuthoredUser user, String appCode) {
        KMDatasetCommandIntentionsResDTO cIData;
        AthenaMessageEvent event = new AthenaMessageEvent();
        HashMap<String, Object> res = new HashMap<String, Object>();
        event.setUser(user);
        if (!StringUtils.isEmpty((CharSequence)appCode) && Objects.nonNull(cIData = this.kmService.dataSetCommandIntentions(event.getUser(), appCode)) && Objects.nonNull(cIData.getAppType())) {
            int appType = cIData.getAppType();
            String version = appType == 12 ? "V2" : "V1";
            res.put("version", version);
            boolean isAileDataApp = appType == 12 || appType == 6;
            res.put("isAgileDataApp", isAileDataApp);
        }
        return res;
    }
}

