/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.tdd.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.dto.tdd.TddThresholdConfig;
import com.digiwin.athena.adt.domain.dto.tdd.TddThresholdRes;
import com.digiwin.athena.adt.domain.tdd.TddService;
import com.digiwin.athena.appcore.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class TddServiceImpl
implements TddService {
    private static final Logger log = LoggerFactory.getLogger(TddServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Value(value="${tdd.url:}")
    private String tddUrl;

    public TddThresholdConfig getTddThresholdConfigByParam(String token, String tid, String appCode) {
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info("\u67e5\u8be2tdd \u6d41\u91cf\u9608\u503c\u914d\u7f6e \u5165\u53c2 tid :{} goodsCode:{}", (Object)tid, (Object)appCode);
        String url = this.tddUrl + "/appThresholdConfigController/getOne?tid=" + tid + "&code=" + appCode;
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", token);
        headers.set("routerkey", tid);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u67e5\u8be2tdd \u6d41\u91cf\u9608\u503c\u914d\u7f6e \u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (responseEntity.getStatusCode().value() != 200 || responseEntity.getBody() == null || !"0".equals(((TddThresholdRes)responseEntity.getBody()).getCode()) || ((TddThresholdRes)responseEntity.getBody()).getData() == null) {
                return null;
            }
            return ((TddThresholdRes)responseEntity.getBody()).getData();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6307\u5b9a\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f(TDD) getTddThresholdConfigByParam", "\u8c03\u7528CAC\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", appCode, "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.TDD_REALTIME_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.TDD_GET_FAIL.getErrCode(), appCode, e.getMessage()});
            throw ErrorCodeEnum.TDD_GET_FAIL.getBusinessException();
        }
    }
}

