/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.listener;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEBaseListener;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.sse.utils.SseEventUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SSEScrumListener
extends SSEBaseListener {
    private static final Logger log = LoggerFactory.getLogger(SSEScrumListener.class);
    private final SSEBaseEvent sseBaseEvent;
    private final SchemaDataHandlerProcessor schemaDataHandlerProcessor;
    private final AgileDataCalculateCostService agileDataCalculateCostService;
    private final AgileDataHandlerProcessor agileDataHandlerProcessor;
    private final AbsAgileDataProcess absAgileDataProcess;

    public SSEScrumListener(SSEBaseEvent sseBaseEvent, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess) {
        this.sseBaseEvent = sseBaseEvent;
        this.schemaDataHandlerProcessor = schemaDataHandlerProcessor;
        this.agileDataCalculateCostService = agileDataCalculateCostService;
        this.agileDataHandlerProcessor = agileDataHandlerProcessor;
        this.absAgileDataProcess = absAgileDataProcess;
    }

    public void onOpen(EventSource eventSource, Response response) {
        this.sseBaseEvent.setScrumEventSource(eventSource);
    }

    public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        String productVersion = this.sseBaseEvent.getEvent().getProductVersion();
        if ("V1".equals(productVersion)) {
            this.sendEventByV1(eventSource, type, data);
        } else if ("V2".equals(productVersion)) {
            this.sendEventByV2(eventSource, type, data);
        } else {
            this.sendEventByV1(eventSource, type, data);
        }
    }

    private void sendEventByV1(EventSource eventSource, @Nullable String type, String data) {
        SseEmitter sseEmitter = this.sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject((String)data);
        String message = res.getString("message");
        String status = res.getString("status");
        if (SseScrumEventEnum.SCRUMBI_ANALYSIS.getEvent().equals(type)) {
            HashMap<String, Object> messageObj = new HashMap<String, Object>();
            messageObj.put("name", message);
            messageObj.put("arguments ", new HashMap());
            EventData.EventMessage eventMessage = EventData.EventMessage.builderNewEventMessage((String)"function_call", messageObj, (AthenaMessageEvent)this.sseBaseEvent.getEvent());
            this.sseBaseEvent.setId(eventMessage.getExtra_info().getCall_id());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.MESSAGE_DETAIL.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessage((String)"function_answer", (Object)message, (String)this.sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageClose((String)"tool_response", (String)this.sseBaseEvent.getId(), (String)status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)) {
            this.sseProcess(res, this.sseBaseEvent);
        } else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)) {
            eventSource.cancel();
        }
    }

    private void sendEventByV2(EventSource eventSource, @Nullable String type, String data) {
        SseEmitter sseEmitter = this.sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject((String)data);
        String message = res.getString("message");
        String status = res.getString("status");
        if (SseScrumEventEnum.SCRUMBI_ANALYSIS.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderNewEventMessageV2((String)"function_call", (Object)message, (AthenaMessageEvent)this.sseBaseEvent.getEvent());
            String callId = this.getV2CallId(eventMessage.getMessage());
            this.sseBaseEvent.setId(callId);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.MESSAGE_DETAIL.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2((String)"function_answer", (Object)message, (String)this.sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)this.sseBaseEvent.getId(), (String)status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)) {
            this.sseProcess(res, this.sseBaseEvent);
        } else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)) {
            eventSource.cancel();
        }
    }

    public String getV2CallId(Object message) {
        Map messageMap = (Map)message;
        Map extraInfo = CommonUtil.convertObjectToMap(messageMap.get("extra_info"));
        return String.valueOf(extraInfo.get("call_id"));
    }

    public void onClosed(EventSource eventSource) {
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        if (!SseEventUtils.noScrumTerminate((List)this.sseBaseEvent.getScrumEventDatas())) {
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }

    public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        String answer;
        log.info("\u8bed\u4e49\u76d1\u542c\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", (Object)t.getMessage());
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        String errorMsg = MessageUtil.getMessageByLanguage((Object)"message.system.schema.error", (String)this.sseBaseEvent.getLang());
        if (Objects.isNull(response) || !response.isSuccessful()) {
            answer = errorMsg;
        } else {
            if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                return;
            }
            answer = errorMsg;
        }
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent());
            eventData.setData(new EventData.EventMessage(SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }

    public void sseProcess(JSONObject res, SSEBaseEvent sseBaseEvent) {
        AthenaMessageEvent event = sseBaseEvent.getEvent();
        MDC.put((String)"traceId", (String)event.getPtxId());
        MDC.put((String)"PtxId", (String)event.getPtxId());
        event.setSseCallId(sseBaseEvent.getId());
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), event.getQuestion(), JsonUtils.objectToString((Object)res), System.currentTimeMillis() - event.getGetQuerySchemaTook()});
        if (res == null || Objects.isNull(res.get((Object)"message"))) {
            return;
        }
        Pair result = this.schemaDataHandlerProcessor.getEnumServiceByType((Enum)SchemaDataEnum.queryTypeEnumByCode((String)sseBaseEvent.getSchemaEnum())).sseProcess(event, res);
        QuerySchemaResDTO schemaResDTO = (QuerySchemaResDTO)result.getRight();
        if (schemaResDTO == null || StringUtils.isEmpty((CharSequence)schemaResDTO.getData().getMethod())) {
            this.absAgileDataProcess.saveQuerySchemaErrorByCode(event, null);
            return;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            return;
        }
        boolean isGo = this.agileDataCalculateCostService.calculateCostByCode(event, schemaResDTO);
        if (!isGo) {
            return;
        }
        String router = String.valueOf(((QuerySchemaResDTO)result.getRight()).getRoute());
        String serviceName = this.absAgileDataProcess.getServiceNameByQuerySchema(router);
        this.agileDataHandlerProcessor.getEnumServiceByType((Enum)AgileDataEnum.queryTypeEnumByCode((String)serviceName)).process(event, schemaResDTO);
    }

    public void sendEventDataMessage(String sendEvent, SseEmitter sseEmitter, EventData.EventMessage eventMessage) {
        EventData eventData = new EventData(sendEvent, eventMessage);
        if (Objects.nonNull(sseEmitter)) {
            SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
        }
    }
}

