package com.digiwin.athena.agiledataecho.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Slf4j
@Configuration
public class MongoTemplateConfig {

    @Value("${spring.data.mongodb.url}")
    private String url;

    @Value("${spring.data.mongodb.database}")
    private String echoInfoLog;

    @Value("${spring.data.mongodb.agileDataPagebase}")
    private String databaseagileDataPage;


    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder()
                .retryWrites(false)
                .applyConnectionString(new ConnectionString(url)).build(), null);
        return new MongoTemplate(client, echoInfoLog);
    }

    @Bean("mongoAgileDataPageViewTemplate")
    public MongoTemplate mongoAgileDataPageViewTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder()
                .retryWrites(false)
                .applyConnectionString(new ConnectionString(url)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate(client, databaseagileDataPage);
        MongoConverter converter = mongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }

        return mongoTemplate;
    }

}
