package com.digiwin.athena.agiledataecho.config.filter;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;
import java.util.EnumSet;

@Configuration
public class SafeMdcFilterConfiguration {

    @Bean
    public FilterRegistrationBean<SafeMdcTraceFilter> safeMdcTraceFilterRegistration(SafeMdcTraceFilter filter) {
        FilterRegistrationBean<SafeMdcTraceFilter> reg = new FilterRegistrationBean<>(filter);
        reg.setName("safeMdcTraceFilter");
        // Run very early so that downstream (including vendor filters/agents) see masked headers
        reg.setOrder(Ordered.LOWEST_PRECEDENCE);
        reg.addUrlPatterns("/*");
        reg.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.ERROR));
        return reg;
    }
}
