package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQueryReq;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.service.aiBoard.EchoAiBoardService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping(value = "/api/ai/agile/echo/aiBoard")
public class EchoAIBoardController {

    @Autowired
    private EchoAiBoardService echoAiBoardService;


    /**
     * 对话看板查询
     * @param aiBoardQueryReq
     * @return
     */
    @PostMapping("getBoard")
    public ResponseEntity<?> getBoard(@RequestBody AIBoardQueryReq aiBoardQueryReq,
                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAiBoardService.queryAgileDataAIBoard(user,aiBoardQueryReq));
    }

    /**
     * 对话看板保存
     * @param echoAIBoardDTO
     * @return
     */
    @PostMapping("saveBoard")
    public ResponseEntity<?> saveBoard(@RequestBody EchoAIBoardDTO echoAIBoardDTO,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAiBoardService.saveAgileDataAIBoard(user,echoAIBoardDTO));
    }

    /**
     * 对话看板修改
     * @param echoAIBoardDTO
     * @return
     */
    @PostMapping("updateBoard")
    public ResponseEntity<?> updateBoard(@RequestBody EchoAIBoardDTO echoAIBoardDTO,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAiBoardService.updateAgileDataAIBoard(user,echoAIBoardDTO));
    }

    /**
     * 对话看板删除
     * @param aiBoardQueryReq
     * @return
     */
    @PostMapping("deleteBoard")
    public ResponseEntity<?> deleteBoard(@RequestBody AIBoardQueryReq aiBoardQueryReq,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAiBoardService.deleteAgileDataAIBoard(user,aiBoardQueryReq));
    }

    /**
     * 获取预览布局
     * @param aiBoardQueryReq
     * @param user
     * @return
     */
    @PostMapping("getPreviewLayout")
    public ResponseEntity<?> getPreviewLayout(HttpServletRequest request,
                                              @RequestBody AIBoardQueryReq aiBoardQueryReq,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        List<GridGroupDTO> a = echoAiBoardService.getPreviewLayout(user,aiBoardQueryReq,locale);
        return ResponseEntityWrapper.wrapperOk(a);
    }

}
