package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.autoData.EchoAutoDataDTO;
import com.digiwin.athena.agiledataecho.service.autoData.EchoAutoDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/ai/agile/echo/autoData")
public class EchoAutoDataController {

    @Autowired
    private EchoAutoDataService echoAutoDataService;


    /**
     * 分析师报告查询
     * @param echoAutoDataDTO
     * @return
     */
    @PostMapping("getReport")
    public ResponseEntity<?> getRport(@RequestBody EchoAutoDataDTO echoAutoDataDTO,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAutoDataService.queryAgileDataAutoData(user,echoAutoDataDTO));
    }

    /**
     * 分析师报告保存
     * @param echoAutoDataDTO
     * @return
     */
    @PostMapping("saveReport")
    public ResponseEntity<?> saveReport(@RequestBody EchoAutoDataDTO echoAutoDataDTO,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAutoDataService.saveAgileDataAutoData(user,echoAutoDataDTO));
    }

    /**
     * 分析师报告修改
     * @param echoAutoDataDTO
     * @return
     */
    @PostMapping("updateReport")
    public ResponseEntity<?> updateReport(@RequestBody EchoAutoDataDTO echoAutoDataDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAutoDataService.updateAgileDataAutoData(user,echoAutoDataDTO));
    }

    /**
     * 分析师报告删除
     * @param echoAutoDataDTO
     * @return
     */
    @PostMapping("deleteReport")
    public ResponseEntity<?> deleteReport(@RequestBody EchoAutoDataDTO echoAutoDataDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoAutoDataService.deleteAgileDataAutoData(user,echoAutoDataDTO));
    }

}
