package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.service.EchoLiteChargingService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping(value = "/api/ai/agile/echo/lite")
public class EchoLiteChargingController {

    @Autowired
    private EchoLiteChargingService echoLiteChargingService;

    /**
     * 扣减体验次数
     * @param user
     * @return
     */
    @GetMapping("/changeCharging")
    public ResponseEntity<?> changeCharging(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoLiteChargingService.changeCharging(user, null));
    }

    /**
     * 初始化体验次数
     * @param params
     * @param user
     * @return
     */
    @PostMapping("/initCharging")
    public ResponseEntity<?> initCharging(@RequestBody Map<String,Object> params,
            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String chargingType = MapUtils.getString(params,"chargingType");
        Integer chargingNum = MapUtils.getInteger(params,"chargingNum");
        Integer chargingRemain = MapUtils.getInteger(params,"chargingRemain");
        echoLiteChargingService.initCharging(user, chargingType,chargingNum,chargingRemain);
        return ResponseEntityWrapper.wrapperOk(true);
    }

    @PostMapping("/initChargingRemain")
    public ResponseEntity<?> initChargingRemain(@RequestBody Map<String,Object> params,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String userId = MapUtils.getString(params,"userId");
        String tenantId = MapUtils.getString(params,"tenantId");
        String chargingType = MapUtils.getString(params,"chargingType");
        Integer chargingRemain = MapUtils.getInteger(params,"chargingRemain");
        echoLiteChargingService.initChargingRemain(userId,tenantId, chargingRemain,chargingType);
        return ResponseEntityWrapper.wrapperOk(true);
    }

}
