package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.UserDefineHabitualDTO;
import com.digiwin.athena.agiledataecho.service.UserDefineHabitualStorage;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping(value = "/api/ai/agile/echo/habit")
public class UserDefineHabitualController {

    @Autowired
    private UserDefineHabitualStorage userDefineHabitualStorage;

    /**
     * 获取用户自定义筛选记录
     * @param user
     * @return
     */
    @GetMapping("/user/get")
    public ResponseEntity<?> getUserHabitual(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userDefineHabitualStorage.getUserHabitual(user));
    }

    /**
     * 上报用户自定义筛选记录
     * @param userDefineHabitualDTO
     * @param user
     * @return
     */
    @PostMapping("/user/save")
    public ResponseEntity<?> saveUserHabitual(@RequestBody UserDefineHabitualDTO userDefineHabitualDTO,
                                                  @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userDefineHabitualStorage.saveUserHabitual(userDefineHabitualDTO, user));
    }

}
