package com.digiwin.athena.agiledataecho.domain;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportChartTypeEnum;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import lombok.Getter;

@Getter
public enum AIBoardScrumBIShowTypeEnum {

    SCRUM_BI_METRIC("METRIC", ECHOConstants.ComponentType.STATISTIC,2,"指标卡"),
    SCRUM_BI_TABLE("TABLE", ECHOConstants.ComponentType.TABLE,0,"表格"),
    SCRUM_BI_LINE("LINE", AgileReportChartTypeEnum.LINE_1.getType(),AgileReportChartTypeEnum.LINE_1.getValue(),"折线图"),
    SCRUM_BI_BAR("BAR", AgileReportChartTypeEnum.BAR_2.getType(),AgileReportChartTypeEnum.BAR_2.getValue(),"柱状图"),
    SCRUM_BI_PIE("PIE", AgileReportChartTypeEnum.PIE_1.getType(),AgileReportChartTypeEnum.PIE_1.getValue(),"柱状图"),
    SCRUM_BI_H_BAR("H_BAR", AgileReportChartTypeEnum.BAR_4.getType(),AgileReportChartTypeEnum.BAR_4.getValue(),"横条图"),
    SCRUM_BI_SCATTER("SCATTER", AgileReportChartTypeEnum.SCATTER_1.getType(),AgileReportChartTypeEnum.SCATTER_1.getValue(),"散点图"),
    SCRUM_BI_BUBBLE("BUBBLE", AgileReportChartTypeEnum.SCATTER_2.getType(),AgileReportChartTypeEnum.SCATTER_2.getValue(),"气泡图");


    private String scrumBIShowType;

    private String echoShowType;

    private Integer echoShowTypeValue;

    private String description;

    AIBoardScrumBIShowTypeEnum(String scrumBIShowType, String echoShowType,
                               Integer echoShowTypeValue,String description){
        this.scrumBIShowType = scrumBIShowType;
        this.echoShowType = echoShowType;
        this.echoShowTypeValue = echoShowTypeValue;
        this.description = description;
    }

    public static Integer getShowTypeValueByBIType(String type) {
        for(AIBoardScrumBIShowTypeEnum aiBoardScrumBIShowTypeEnum : AIBoardScrumBIShowTypeEnum.values()){
            if(type.equals(aiBoardScrumBIShowTypeEnum.scrumBIShowType)){
                return aiBoardScrumBIShowTypeEnum.echoShowTypeValue;
            }
        }
        return null;
    }
}
