package com.digiwin.athena.agiledataecho.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: SunHong
 * @Date: 2024/7/22 15:35
 * @Description:
 */
@Data
@TableName("echo_information")
public class EchoInformation implements Serializable {

    @TableId(value = "id",type = IdType.AUTO)
    private Long id;

    private String appCode;

    private String appName;

    private String complexAppName;

    private long messageId;

    private String pixBackendId;

    private String pixFrontId;

    private String description;

    private String complexDescription;

    private String content;

    private String complexContent;

    private String extend;

    private String complexExtend;

    private String informationType;

    private Date createTime;


    public static EchoInformation CopySubStrBean(EchoInformationReqDTO copy) {
        EchoInformation bean = new EchoInformation();
        BeanUtils.copyProperties(copy, bean);
        // 字段类型修改为text
//        if (StringUtils.isNotEmpty(bean.getDescription())) {
//            int descriptionLength = bean.getDescription().length();
//            bean.setDescription(descriptionLength > 1000? bean.getDescription().substring(0, 1000) : bean.getDescription());
//        }
//        if (StringUtils.isNotEmpty(bean.getContent())) {
//            int contentLength = bean.getContent().length();
//            bean.setContent(contentLength > 1000? bean.getContent().substring(0, 1000) : bean.getContent());
//        }
//        if (StringUtils.isNotEmpty(bean.getExtend())) {
//            int extendLength = bean.getExtend().length();
//            bean.setExtend(extendLength > 1000? bean.getExtend().substring(0, 1000) : bean.getExtend());
//        }
        return bean;
    }
}
