package com.digiwin.athena.agiledataecho.dto.aiBoard;

import lombok.Data;

import java.util.List;

@Data
public class AIBoardLayout {

    /**
     * 总体布局
     */
    private layoutAll overallLayout;

    /**
     * 区域信息
     */
    private List<layoutArea> charts;

    @Data
    public static class layoutArea{

        private String chartId;

        //重要度，决定每行图形的优先级，谁排在前面，谁排在后面
        private Double importance;

        //行数,代表此图形在第几行
        private Integer row;


        private String showType;


        private String title;

        /**
         * 宽
         */
        private layoutDimensions dimensions;

        /**
         * 高
         */
        private layoutPosition position;
    }



    @Data
    public static class layoutAll{

        /**
         * 宽
         */
        private Integer layoutCols;

        /**
         * 高
         */
        private Integer layoutRows;
    }

    /**
     * 起始位置
     */
    @Data
    public static class layoutIndex{

        /**
         * 起点
         */
        private Integer start;

        /**
         * 终点
         */
        private Integer end;
    }

    /**
     * 区域坐标
     */
    @Data
    public static class layoutPosition{

        /**
         * 宽起始
         */
        private layoutIndex layoutCol;

        /**
         * 高起始
         */
        private layoutIndex layoutRow;
    }

    /**
     * 区域占比
     */
    @Data
    public static class layoutDimensions{

        /**
         * 区域宽
         */
        private Integer areaCols;

        /**
         * 区域高
         */
        private Integer areaRow;
    }

}