package com.digiwin.athena.agiledataecho.dto.aiBoard;

import com.digiwin.athena.show.domain.ppt.AgileDataFileAnalyzeDTO;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AIBoardQuestionDTO {

    /**
     * 规划问句ID
     */
    private Long questionId;

    /**
     * 分析规划问句
     */
    private String question;

    /**
     * 区域标题
     */
    private String chartTitle;

    /**
     * 推荐呈现类型
     */
    private String showType;

    /**
     * 取数入参
     */
    private Map<String,Object> getDataParams;

    /**
     * 问句分析状态
     * 0.成功1.失败2.分析中
     */
    private Integer analyzeStatus;

    /**
     * 分析结果
     */
    private AgileDataFileAnalyzeDTO analyzeResult;

    /**
     * 数据集集合
     */
    private List<String> datasetIds;

    /**
     * 执行解析问数的唯一key
     */
    private Long analyzeMessageId;


}
