package com.digiwin.athena.agiledataecho.dto.aiBoard;

import lombok.Data;

import java.time.LocalTime;
import java.util.List;

@Data
public class EchoAIBoardDTO {

    /**
     * 消息ID
     */
    private Long messageId;

    /**
     * 看板ID
     */
    private String boardId;

    /**
     * 消息状态0.未执行 1.已执行 2.执行中
     */
    private Integer messageStatus;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 看板标题
     */
    private String boardTitle;

    /**
     * 预览布局
     */
    private AIBoardLayout previewLayout;

    /**
     * 看板布局
     */
    private AIBoardLayout boardLayout;

    /**
     * 规划问句集合
     */
    private List<AIBoardQuestionDTO> questionInfo;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 创建日期
     */
    private LocalTime createTime;

    /**
     * 创建日期
     */
    private LocalTime updateTime;

}
