package com.digiwin.athena.agiledataecho.dto.mongodb;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * mongoDB新增DTO
 *
 * @author xujinc
 * @date 2024/7/31
 */
@Data
public class MongoDbAddDTO {

    /**
     * 集合名称
     */
    @NotBlank(message = "collectionName不能为空")
    private String collectionName;

    /**
     * 新增的数据
     * key对应数据库字段，value对应值
     */
    private Map<String, Object> mapData;

    /**
     * 口令
     */
    @NotBlank(message = "口令不能为空")
    private String wordOfCommand;

}