package com.digiwin.athena.agiledataecho.mongodb.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.Map;

/**
 * 体验角色model
 *
 * @author yanfeng
 * @date 2024/10/22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document(collection = "agile_experience_role_config_data")
public class EchoExperienceRoleConfigData implements Serializable {

    private static final long serialVersionUID = -2199790037720309364L;

    @Id
    private String id;

    /**
     * 角色id
     */
    private String roleId;

    /**
     * 角色名称
     */
    @Transient
    private String roleName;

    /**
     * 配置参数
     * Map key： CN、TW
     */
    @JsonIgnore
    private Map<String, Map<String, String>> parameterData;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 是否删除
     */
    private Boolean deleted;

    /**
     * 设置角色名称
     *
     * @param district 地区(CN、TW)
     * @param locale   语言(zh_CN、zh_TW、en_US)
     */
    public void setRoleName(String district, String locale) {
        if (ObjectUtils.isEmpty(this.parameterData) || !this.parameterData.containsKey(district)) {
            return;
        }
        Map<String, String> map = this.parameterData.get(district);
        if (ObjectUtils.isEmpty(map)) {
            return;
        }
        this.roleName = map.get(locale);
    }

}