package com.digiwin.athena.agiledataecho.mongodb.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;

/**
 * 引导提问相似度匹配(输入框)
 *
 * @author yanfeng
 * @date 2024/10/25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document(collection = "agile_fuzzy_matching_config_data")
public class EchoFuzzyMatchingConfigData implements Serializable {

    @Id
    private String id;

    /**
     * 是否启动模糊匹配
     */
    private boolean isFuzzyMatching;

    /**
     * 模糊匹配精确度 0-1之间
     */
    private Double precision;

}