package com.digiwin.athena.agiledataecho.mongodb.domain;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/8/5 10:40
 * @Description:
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document("agile_echo_info_log")
public class EchoInfoMongoData {

    @Id
    private String id;

    private String appCode;

    private String appName;

    private long messageId;

    private String pixBackendId;

    private String pixFrontId;

    private String description;

    private String content;

    private String extend;

    private String informationType;

    private Date createTime;

    private LocalDateTime updateTime;

    private List<Map<String,Object>> selectMultiple;

    /**
     * 截取标识语句
     */
    private String dataTipMessage;

    private List<Map<String,Object>> stepAnalysis;

    /**
     * 筛选条件json
     */
    private List<Map<String,Object>> stepFilterAnalysis;
}
