package com.digiwin.athena.agiledataecho.proxy.ade;

import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineAnalysisModel;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineFileDownModel;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

/**
 * 敏数引擎
 */
public interface AgileDataEngineService {

    /**
     * 获取数据明细下载地址
     * @param user
     * @param params
     * @param locale
     * @return
     */
    AgileDataEngineFileDownModel getFileDownUrl(AuthoredUser user, Map<String,Object> params,String locale);

    /**
     * 获取问句解析结果
     * @param user
     * @param params
     * @param locale
     * @return
     */
    AgileDataEngineAnalysisModel getAnalysisData(AuthoredUser user, Map<String,Object> params, String locale);

    AgileDataEngineFileDownModel getFileDownUrlV2(AuthoredUser user, Map<String, Object> adeParams, String locale);
}
