package com.digiwin.athena.agiledataecho.proxy.ade.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.AthenaDapApiResponse;
import com.digiwin.athena.agiledataecho.proxy.ade.AgileDataEngineService;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineAnalysisModel;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineFileDownModel;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AgileDataEngineServiceImpl implements AgileDataEngineService {

    @Autowired
    private EchoEnvProperties echoEnvProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${appToken:}")
    private String appToken;

    @Override
    public AgileDataEngineFileDownModel getFileDownUrl(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = echoEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/download/detail";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        params.put("userId",user.getUserId());
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            log.info("获取下载信息入参：{}", JsonUtils.objectToString(params));
            ResponseEntity<BaseResultDTO<AgileDataEngineFileDownModel>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<AgileDataEngineFileDownModel>>() {
                    });
            log.info("获取下载信息结果集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.ADE_GET_FILE_URL_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }

    @Override
    public AgileDataEngineAnalysisModel getAnalysisData(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = echoEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/getEssentialFactor";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            log.info("获取解析结果入参：{}", JsonUtils.objectToString(params));
            ResponseEntity<BaseResultDTO<AgileDataEngineAnalysisModel>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<AgileDataEngineAnalysisModel>>() {
                    });
            log.info("获取解析结果集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.ADE_GET_ANALYSIS_URL_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }

    @Override
    public AgileDataEngineFileDownModel getFileDownUrlV2(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = echoEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/download/detail/dataset";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        params.put("userId",user.getUserId());
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            log.info("获取下载信息入参：{}", JsonUtils.objectToString(params));
            ResponseEntity<BaseResultDTO<AgileDataEngineFileDownModel>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<AgileDataEngineFileDownModel>>() {
                    });
            log.info("获取下载信息结果集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.ADE_GET_FILE_URL_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }
}
