package com.digiwin.athena.agiledataecho.proxy.iam;

import com.digiwin.athena.agiledataecho.domain.InnerExistDTO;
import com.digiwin.athena.agiledataecho.domain.PersonalizedDto;
import com.digiwin.athena.agiledataecho.domain.ReplyInviteResultDTO;
import com.digiwin.athena.agiledataecho.domain.UserMetadataDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserDTO;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

public interface UserService {
    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @param token  合法的token
     * @return 用户基本信息
     */
    UserDTO query(String userId, String token);

    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    UserDTO query(String userId);

    /**
     * 根据用户email获取用户相关的信息
     *
     * @param email 用户email
     * @return 用户基本信息
     */
    UserDTO queryByEmail(String email);

    /**
     * 根据用户手机号获取用户相关的信息
     *
     * @param phone 用户手机号
     * @return 用户基本信息
     */
    UserDTO queryByPhone(String phone);

    /**
     * 根据用户email和租户Id获取用户相关的信息
     *
     * @param email 用户email
     * @return 用户基本信息
     */
    UserDTO queryByEmail(String email,String tenantId);

    /**
     * 根据用户phone和租户Id获取用户相关的信息
     *
     * @param phone 用户phone
     * @return 用户基本信息
     */
    UserDTO queryByPhone(String phone, String tenantId);

    /**
     * 根据归户信息获取用户相关的信息
     *
     * @param mappingApp   归户的系统
     * @param account      帐套，可以传空
     * @param verifyUserId 归户系统的用户id
     * @param token        合法的token
     * @return 用户基本信息
     */
    UserDTO query(String mappingApp, String account, String verifyUserId, String token);



    /**
     * 通过用户ID 获取员工的多语言
     *
     * @param userId
     * @param token
     * @return
     */
    String getUserLangNameByUserId(String userId, String tenantId, String token);

    /**
     * 通过用户ID 获取是否静默
     *
     * @param userId
     * @param token
     * @return
     */
    boolean getMessageDoNotDisturbUserId(String userId, String tenantId, String token);

    /**
     * 获取目标用户：优先取当前用户的代理用户，否则返回当前用户
     * @param userId
     * @param token
     * @return
     */
    UserDTO getTargetUser(String userId, String token);

    /**
     * 获取用户的偏好联系方式
     *
     * @param userId   用户sid
     * @param tenantSid 租户sid，区分租户时，传入租户sid；不区分租户时，传入0
     * @param token 用户token信息
     * @return
     */
    String getUserAcceptContacts(String userId, Long tenantSid, String token);

    /**
     * 获取指定用户所有租户下的元数据信息
     * @param userId
     * @return
     */
    UserMetadataDTO getUserMetadataAllTenant(String userId);

    /**
     * 根据userSid获取租户语言别设置
     *
     * @param userId
     * @param token
     * @return
     */
    String getUserLangMetadataAllTenant(String userId, String token);

    /**
     * 获取指定用户所有租户下的元数据信息
     * @param userId
     * @return
     */
    UserMetadataDTO getUserMetadataInAllTenant(String userId);

    /**
     * 企業邀請用戶加入【Athena】【4.15】
     * @param email
     * @param tenantId
     * @param appCode
     * @param locale
     */
    ReplyInviteResultDTO replyInvite(String email, String tenantId, String appCode, String locale);

    /**
     * 判断邮箱帐号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     * @param email
     * @return
     */
    InnerExistDTO emailInnerExist(String email);


    /**
     * 判断手机号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     * @param phone
     * @return
     */
    InnerExistDTO phoneInnerExist(String phone);


    /**
     * 查询用户的个性化设置数据
     *
     * @param tenantSid 租户SID，注意非租户id
     * @param userId    用户id
     * @param key       需要查询的key
     * @param catalogId 类目id
     * @return PersonalizedDto
     */
    PersonalizedDto queryPersonalizedInfo(Long tenantSid, String userId, String key, String catalogId);


    /**
     * 查询用户的个性化设置数据
     *
     * @param userId   用户id
     * @param metaList 需要修改的参数列表
     * @return PersonalizedDto
     */
    int updatePersonalizedInfo(String userId, List<Object> metaList) ;


    /**
     * 根据用户id查询出用户的
     * @param userId 用户id
     * @return email
     */
    String queryUserEmail(String userId);

    /**
     * 根据邮箱获取任务的实际执行人
     * @Author：SYQ
     * @Date：2021/7/2 11:21
     */
    String getActualPerformId(String tenantId, String emailAddress, AuthoredUser user);

    ResponseEntity<Map> invoiceTaxno(String unifyNumber, AuthoredUser user);

    /**
     * 获取内部员工
     * @Author：SYQ
     * @Date：2021/6/15 14:42
     */
    List<String> getEmployee(List<String> userList,AuthoredUser user);

    /**
     * 查询用户类型
     *
     * @param userId
     * @param token
     * @return 0：内部用户；1：外部用户
     */
    Integer queryUserType(String userId, String token);
}

