package com.digiwin.athena.agiledataecho.proxy.scrumbi.dto;

import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

import java.util.List;

@Data
public class ScrumBILayoutReq {

    private LayoutData data;


    @Data
    public static class LayoutData{
        private String boardTitle;

        private List<BoardDesign> BoardDesign;
    }



    @Data
    public static class BoardDesign{

        private Long id;

        private String chartTitle;

        private List<String> dataSetId;

        private String question;

        private String chartType;

    }

    public static ScrumBILayoutReq buildScrumBILayoutReq(EchoAIBoardDTO echoAIBoardDTO){
        ScrumBILayoutReq scrumBILayoutReq = new ScrumBILayoutReq();
        LayoutData data = new LayoutData();
        scrumBILayoutReq.setData(data);
        data.setBoardTitle(echoAIBoardDTO.getBoardTitle());
        if(CollectionUtils.isNotEmpty(echoAIBoardDTO.getQuestionInfo())) {
            List<ScrumBILayoutReq.BoardDesign> boardDesigns = Lists.newArrayList();
            data.setBoardDesign(boardDesigns);
            echoAIBoardDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                ScrumBILayoutReq.BoardDesign boardDesign = new ScrumBILayoutReq.BoardDesign();
                boardDesign.setId(questionInfo.getQuestionId());
                boardDesign.setChartTitle(questionInfo.getQuestion());
                boardDesign.setQuestion(questionInfo.getQuestion());
                boardDesign.setChartType(questionInfo.getShowType());
                boardDesign.setDataSetId(questionInfo.getDatasetIds());
                boardDesigns.add(boardDesign);
            });
        }
        return scrumBILayoutReq;
    }

}
