package com.digiwin.athena.agiledataecho.proxy.scrumbi.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardLayoutDTO;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardLayoutGroupDTO;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.ScrumBIService;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutReq;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutRes;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class ScrumBIServiceImpl implements ScrumBIService {

    @Autowired
    EchoEnvProperties echoEnvProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public List<EchoAIBoardLayoutDTO> getAIBoardLayout(AuthoredUser user, ScrumBILayoutReq aiBoardQueryReq, String locale) {
        String url = echoEnvProperties.getChatBIUrl() + "/scrumbi/layout/design";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("routerkey", user.getTenantId());
            headers.add("token", user.getToken());
            headers.add("proxy_token", user.getToken());
            headers.add("security-token", null);

            HttpEntity requestEntity = new HttpEntity<>(aiBoardQueryReq, headers);

            ResponseEntity<ScrumBILayoutRes> resultDTOResponseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<ScrumBILayoutRes>() {
                    });
            if(resultDTOResponseEntity.getBody() != null && Objects.equals(resultDTOResponseEntity.getBody().getCode(), "200")) {
                ScrumBILayoutRes.ScrumBILayoutData data = resultDTOResponseEntity.getBody().getData();
                log.info("获取语义生成布局信息,{}", JsonUtils.objectToString(data));
                if (!ObjectUtils.isEmpty(data)&& Objects.equals(data.getCode(),"0")){
                    EchoAIBoardLayoutGroupDTO groupDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(data.getData()), EchoAIBoardLayoutGroupDTO.class);
                    if (ObjectUtils.isEmpty(groupDTO.getLayout())){
                        return new ArrayList<>();
                    }
                    return JsonUtils.jsonToObject(JsonUtils.objectToString(groupDTO.getLayout()), new TypeReference<List<EchoAIBoardLayoutDTO>>() {});
                }
            }
            return new ArrayList<>();
        } catch (Exception e) {
            log.error("获取语义生成布局失败，{}",e.getMessage());
            return new ArrayList<>();
        }
    }
}