package com.digiwin.athena.agiledataecho.service;

import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinUnReadResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinUnReadSaveDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;

/**
 * 敏捷数据获取GMC公告服务
 *
 * @author yanfeng
 * @date 2024/7/23
 */
public interface EchoGmcService {

    /**
     * 查询已读公告列表
     *
     * @param user
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<GmcBulletinResultDTO> queryReadBulletinList(AuthoredUser user, Integer pageNum, Integer pageSize);

    /**
     * 查询未读公告列表
     *
     * @param user
     * @param pageNum
     * @param pageSize
     * @return
     */
    GmcBulletinUnReadResultDTO queryUnreadBulletinList(AuthoredUser user, Integer pageNum, Integer pageSize);

    /**
     * 保存已读公告
     *
     * @param saveDTO
     * @return
     */
    Boolean saveReadBulletin(AuthoredUser user, GmcBulletinUnReadSaveDTO saveDTO);
}