package com.digiwin.athena.agiledataecho.service;

import com.digiwin.athena.agiledataecho.dto.EchoExperienceRoleConfigDataQueryDTO;
import com.digiwin.athena.agiledataecho.dto.EchoOpeningRemarksConfigResultDTO;
import com.digiwin.athena.agiledataecho.dto.EchoPageConfigProductBulletinQueryDTO;
import com.digiwin.athena.agiledataecho.dto.EchoPageConfigProductBulletinResultDTO;
import com.digiwin.athena.agiledataecho.mongodb.domain.*;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KMCommandIntentionsDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;

/**
 * 敏捷数据页面配置服务
 *
 * @author yanfeng
 * @date 2024/8/21
 */
public interface EchoPageConfigService {

    /**
     * 查询产品公告配置列表
     *
     * @param queryDTO
     * @return
     */
    List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(AuthoredUser user, EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 保存或更新产品公告配置
     *
     * @param user
     * @param saveDTO
     * @return
     */
    EchoProductBulletinConfigData saveProductBulletinConfig(AuthoredUser user, EchoProductBulletinConfigData saveDTO);

    /**
     * 保存或更新开场白配置
     *
     * @param user
     * @param saveDTO
     * @return
     */
    EchoOpeningRemarksConfigData saveOpeningRemarksConfig(AuthoredUser user, EchoOpeningRemarksConfigData saveDTO);


    /**
     * 查询开场白配置
     *
     * @param queryDTO 助手名称
     * @param user
     * @return
     */
    EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(AuthoredUser user, EchoPageConfigProductBulletinQueryDTO queryDTO);

    /**
     * 查询移动端角色配置列表
     *
     * @param queryDTO
     * @return
     */
    List<EchoExperienceRoleConfigData> queryExperienceRoleConfigList(EchoExperienceRoleConfigDataQueryDTO queryDTO);

    /**
     * Lite版查询移动端上传限制说明配置
     *
     * @param user
     * @return
     */
    EchoLiteUploadLimitationsConfigData queryLiteUploadLimitationsConfig(AuthoredUser user);

    /**
     * KM场景意图模型-指令集分组列表
     * @param user
     * @return
     */
    List<KMCommandIntentionsDTO> queryCommandIntentions(AuthoredUser user);

    /**
     * 查询引导提问模糊匹配配置
     * @param user
     * @return
     */
    EchoFuzzyMatchingConfigData queryFuzzyMatchingConfig(AuthoredUser user);
}